package com.hyperscience.saas.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum HttpVerb {
  Get("GET"), Post("POST");
  final String value;

  HttpVerb(String value) {
    this.value = value;
  }

  private static final Map<String, HttpVerb> BY_VALUE = new HashMap<>();

  static {
    Arrays.stream(values()).forEach((hv) -> BY_VALUE.put(hv.value, hv));
  }

  public HttpVerb fromValue(String value) {
    value = value != null ? value.toUpperCase() : "";
    return BY_VALUE.get(value);
  }
}
