package com.hyperscience.saas.auth.model;

import java.util.Base64;

/**
 * Credentials object to be used by the API calls.
 */
public abstract class Credentials {
  private final String clientId;
  private final String clientSecret;

  public Credentials(String clientId, String clientSecret) {
    this.clientId = clientId;
    this.clientSecret = clientSecret;
  }

  private static String decodeBase64String(String b64Str) {
    String paddedB64 = padBase64String(b64Str);
    return new String(Base64.getDecoder().decode(paddedB64));
  }

  private static String padBase64String(String b64Str) {
    int remainder = b64Str.length() % 4;
    StringBuilder result = new StringBuilder(b64Str);

    switch (remainder) {
      case 2:
        result.append("==");
        break;
      case 3:
        result.append("=");
        break;
      default:
        break;
    }

    return result.toString();
  }

  /**
   * Decode base64 client id.
   *
   * @return - decoded client id
   */
  public String decodeClientId() {
    String decodedClientId;
    try {
      decodedClientId = decodeBase64String(clientId);
    } catch (Exception ex) {
      throw new IllegalArgumentException("invalid client id format");
    }

    return decodedClientId;
  }

  /**
   * Decode base64 client secret.
   *
   * @return - decoded client secret
   */
  public String decodeClientSecret() {
    if (clientSecret == null || clientSecret.isEmpty()) {
      throw new IllegalArgumentException("invalid client secret");
    }

    return clientSecret;
  }
}
