package com.hyperscience.saas.auth.model;

/**
 * Provide credentials using environment credentials HS_CLIENT_ID and HS_CLIENT_SECRET.
 */
public class EnvironmentCredentialsProvider extends Credentials {
  private static final String CLIENT_ID_KEY = "HS_CLIENT_ID";
  private static final String CLIENT_SECRET_KEY = "HS_CLIENT_SECRET";

  public EnvironmentCredentialsProvider() {
    super(getEnvValue(CLIENT_ID_KEY), getEnvValue(CLIENT_SECRET_KEY));
  }

  private static String getEnvValue(String key) {
    String value = System.getenv(key);
    if (value == null) {
      throw new IllegalArgumentException(key + " is not set!");
    }

    return value;
  }
}
