package com.hyperscience.saas.auth.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Getter;
import lombok.Setter;

/**
 * Okta Request DTO class.
 */
@Getter
@Setter
public class OktaRequestDto implements Serializable {
  static final long serialVersionUID = -3837288242L;

  @JsonProperty("username")
  String username;

  @JsonProperty("password")
  String password;

  @JsonProperty("options")
  Options options;

  /**
   * OktaRequest constructor.
   *
   * @param username - username to use in the request
   * @param password - password to use in the request
   */
  public OktaRequestDto(String username, String password) {
    this.options = new Options();
    this.username = username;
    this.password = password;
  }

  static class Options {
    @JsonProperty("multiOptionalFactorEnroll")
    boolean multiOptionalFactorEnroll;

    @JsonProperty("warnBeforePasswordExpired")
    boolean warnBeforePasswordExpired;
  }
}
