package com.hyperscience.saas.config;

import com.hyperscience.saas.utils.Utils;
import java.util.Properties;

/**
 * Singleton that holds Properties.
 */
public class PropertiesSingleton {
  private static Properties saasClientProperties;

  /**
   * Get Saas Client Properties loaded from
   * saas-client.properties file
   * @return SaasClientProperties
   */
  public static Properties getSaasClientProperties() {
    if (saasClientProperties == null) {
      saasClientProperties = Utils.loadConfig("saas-client.properties");
    }

    return saasClientProperties;
  }
}
