package com.hyperscience.saas.config;

import com.hyperscience.saas.api.utils.Constants;
import lombok.Getter;

@Getter
public class TimeoutConfiguration {
  private static TimeoutConfiguration defaultTimeoutConfiguration = null;
  private final int connectionTimeout;
  private final int readTimeout;

  /**
   * Builds new TimeoutConfiguration Object.
   *
   * @param connectionTimeout    time period in which the client
   *                             should establish a connection with a target host
   * @param readTimeoutInSeconds maximum time of inactivity between two data packets
   *                             when waiting for the server's response
   */
  public TimeoutConfiguration(
      int connectionTimeout,
      int readTimeoutInSeconds
  ) {
    this.connectionTimeout = connectionTimeout;
    this.readTimeout = readTimeoutInSeconds;
  }

  /**
   * Retrieve default timeout configuration Singleton.
   *
   * @return default timeout configuration with
   *         connection_timeout=60 seconds and read_timeout=60 seconds
   */
  public static TimeoutConfiguration getDefaultTimeoutConfiguration() {
    if (defaultTimeoutConfiguration == null) {
      defaultTimeoutConfiguration = new TimeoutConfiguration(
          Constants.CONNECTION_TIMEOUT,
          Constants.READ_TIMEOUT
      );
    }

    return defaultTimeoutConfiguration;
  }
}
