package com.hyperscience.saas.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import lombok.extern.slf4j.Slf4j;

/**
 * Utils class.
 */
@Slf4j
public class Utils {
  /**
   * Load configuraion as Properties.
   *
   * @param propertiesFileName - properties file name
   * @return - Properties
   */
  public static Properties loadConfig(final String propertiesFileName) {
    Properties config = new Properties();
    InputStream inputStream = ClassLoader.getSystemResourceAsStream(propertiesFileName);
    try {
      config.load(inputStream);
    } catch (IOException ioException) {
      log.error("failed to load configuration for file: {}", propertiesFileName);
    }
    return config;
  }
}
