package com.hyperscience.saas.utils;

/**
 * Base validations class.
 */
public class Validator {

  /**
   * Validates number is greater than 0.
   *
   * @param number - Number to validate
   * @param message - Validation message in case of error
   */
  public static void validateGreaterThanZero(int number, String message) {
    if (number <= 0) {
      throw new IllegalStateException(
          String.format("GREATER_THAN_ZERO_VALIDATION_ERROR: %s", message)
      );
    }
  }

  /**
   * Validates obj is not null.
   *
   * @param obj - Object to validate
   * @param message - Validation message in case of error
   */
  public static void validateNotNull(Object obj, String message) {
    if (obj == null) {
      throw new IllegalStateException(String.format("NULL_VALIDATION_ERROR: %s", message));
    }
  }

  /**
   * Validates obj is not empty.
   *
   * @param str - String to validate
   * @param message - Validation message in case of error
   */
  public static void validateNotEmpty(String str, String message) {
    validateNotNull(str, message);
    if (str.isEmpty()) {
      throw new IllegalStateException(String.format("EMPTY_VALIDATION_ERROR: %s", message));
    }
  }
}
