/*
 * Decompiled with CFR 0.152.
 */
package com.hyperscience.saas.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hyperscience.saas.api.RequestHandler;
import com.hyperscience.saas.api.enums.HttpVerb;
import com.hyperscience.saas.api.enums.SupportedMediaType;
import com.hyperscience.saas.auth.OauthService;
import com.hyperscience.saas.auth.model.Credentials;
import com.hyperscience.saas.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestHandlerImpl
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(RequestHandlerImpl.class);
    static final String USER_AGENT_HEADER_VALUE;
    static final Tika TIKA;
    private static final ObjectMapper om;
    OauthService oauthService;
    Credentials credentials;
    Configuration configuration;
    String cookie;
    String csrfToken = "";
    private final OkHttpClient client;
    private boolean initialized = false;

    public RequestHandlerImpl(Credentials credentials, Configuration configuration, OauthService oauthService) {
        this.credentials = credentials;
        this.oauthService = oauthService;
        this.configuration = configuration;
        this.client = new OkHttpClient().newBuilder().followRedirects(false).connectTimeout((long)configuration.getTimeOutConfiguration().getConnectionTimeout(), TimeUnit.SECONDS).readTimeout((long)configuration.getTimeOutConfiguration().getReadTimeout(), TimeUnit.SECONDS).build();
    }

    @Override
    public void init() throws IOException {
        this.initialized = true;
        this.cookie = this.oauthService.login(this.credentials);
        this.csrfToken = this.getCsrfToken(this.cookie);
    }

    @Override
    public Response handleRequest(HttpVerb httpVerb, String url, Map<String, Object> data, SupportedMediaType supportedMediaType) throws IOException {
        return this.handleRequest(httpVerb, url, (MultiValuedMap<String, Object>)new ArrayListValuedHashMap(data), supportedMediaType);
    }

    @Override
    public Response handleRequest(HttpVerb httpVerb, String url, MultiValuedMap<String, Object> data, SupportedMediaType supportedMediaType) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        String preparedUrl = url.startsWith("/") ? url.substring(1) : url;
        Request.Builder requestBuilder = this.createRequest(httpVerb, preparedUrl, data, supportedMediaType);
        requestBuilder.header("Cookie", String.format("csrftoken=%s; %s", this.csrfToken, this.cookie));
        requestBuilder.header("User-Agent", USER_AGENT_HEADER_VALUE);
        requestBuilder.header("X-CSRFToken", this.csrfToken);
        requestBuilder.header("Referer", String.format("https://%s", this.configuration.getHyperscienceDomain()));
        Response response = this.callClient(requestBuilder);
        if (this.isSessionExpired(response)) {
            this.init();
            requestBuilder.header("Cookie", String.format("csrftoken=%s; %s", this.csrfToken, this.cookie));
            requestBuilder.header("X-CSRFToken", this.csrfToken);
            response = this.callClient(requestBuilder);
        }
        return response;
    }

    public Response callClient(Request.Builder requestBuilder) throws IOException {
        Call call = this.client.newCall(requestBuilder.build());
        return call.execute();
    }

    String getCsrfToken(String cookie) throws JsonProcessingException {
        String csrfToken = "";
        Request.Builder requestBuilder = this.createRequest(HttpVerb.Get, "", (MultiValuedMap<String, Object>)new ArrayListValuedHashMap(Collections.emptyMap()), null);
        requestBuilder.header("Cookie", cookie);
        requestBuilder.header("User-Agent", USER_AGENT_HEADER_VALUE);
        try {
            Response response = this.callClient(requestBuilder);
            if (response.isSuccessful()) {
                String responseCookie = response.header("Set-Cookie", "");
                String[] csrfTokenParts = responseCookie.split(";");
                String csrfCookie = Arrays.stream(csrfTokenParts).filter(cookiePart -> cookiePart.startsWith("csrftoken=")).findFirst().orElse("csrftoken=");
                csrfToken = csrfCookie.split("=")[1];
            }
        }
        catch (IOException ioException) {
            log.error("Failed to get CSRF token, Error: {}", (Object)ioException.getMessage());
        }
        return csrfToken;
    }

    private boolean isSessionExpired(Response response) {
        boolean isCookieExpired = response.code() == 302 && response.header("Location") != null && response.header("Location").contains(this.configuration.getAuthServer());
        boolean isCsrfTokenExpired = false;
        try {
            isCsrfTokenExpired = response.code() == 403 && response.peekBody(512L).string().contains("CSRF Failed");
        }
        catch (IOException ioException) {
            log.warn("Failed to read the response, request csrf token verification skipped.");
        }
        return isCookieExpired || isCsrfTokenExpired;
    }

    private Request.Builder createRequest(HttpVerb httpVerb, String url, MultiValuedMap<String, Object> data, SupportedMediaType contentType) throws JsonProcessingException {
        Request.Builder requestBuilder = new Request.Builder();
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host(this.configuration.getHyperscienceDomain()).addEncodedPathSegments(url);
        switch (httpVerb) {
            case Get: {
                requestBuilder = this.createGetRequestBody(requestBuilder, urlBuilder, data);
                break;
            }
            case Post: {
                requestBuilder = this.createPostRequestBody(requestBuilder, urlBuilder, data, contentType);
                break;
            }
            default: {
                throw new IllegalStateException((Object)((Object)httpVerb) + "is not a supported HTTP verb!");
            }
        }
        return requestBuilder;
    }

    private Request.Builder createGetRequestBody(Request.Builder requestBuilder, HttpUrl.Builder urlBuilder, MultiValuedMap<String, Object> data) {
        if (data != null) {
            data.asMap().forEach((key, values) -> values.forEach(value -> urlBuilder.addQueryParameter(key, value.toString())));
        }
        requestBuilder.get().url(urlBuilder.build().url());
        return requestBuilder;
    }

    private Request.Builder createPostRequestBody(Request.Builder requestBuilder, HttpUrl.Builder urlBuilder, MultiValuedMap<String, Object> data, SupportedMediaType contentType) throws JsonProcessingException {
        requestBuilder.url(urlBuilder.build().url());
        switch (contentType) {
            case FormUrlEncoded: {
                FormBody.Builder formBodyBuilder = new FormBody.Builder();
                data.asMap().forEach((key, values) -> values.forEach(value -> formBodyBuilder.add(key, value.toString())));
                requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
                requestBuilder.post((RequestBody)formBodyBuilder.build());
                break;
            }
            case MultipartFormData: {
                MultipartBody.Builder multiPartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                data.asMap().forEach((key, values) -> values.forEach(value -> {
                    String stringValue = value.toString();
                    if (this.isFile(stringValue)) {
                        this.addFile(multiPartBuilder, (String)key, stringValue);
                    } else {
                        multiPartBuilder.addFormDataPart(key, stringValue);
                    }
                }));
                requestBuilder.post((RequestBody)multiPartBuilder.build());
                break;
            }
            case ApplicationJson: {
                HashMap jsonMap = new HashMap();
                data.asMap().forEach((key, value) -> {
                    if (value.size() != 1) {
                        throw new IllegalStateException("Not a valid json");
                    }
                    jsonMap.put(key, new ArrayList(value).get(0));
                });
                String jsonString = om.writeValueAsString(jsonMap);
                RequestBody body = RequestBody.create((String)jsonString, (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
                requestBuilder.addHeader("Content-Type", SupportedMediaType.ApplicationJson.getValue());
                requestBuilder.post(body);
                break;
            }
            default: {
                throw new IllegalStateException((Object)((Object)contentType) + "is not supported contentType");
            }
        }
        return requestBuilder;
    }

    private void addFile(MultipartBody.Builder multiPartBuilder, String key, String value) {
        try {
            Path path = Paths.get(value, new String[0]);
            File file = new File(value);
            String mimeType = TIKA.detect(file);
            multiPartBuilder.addFormDataPart(key, path.getFileName().toString(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)mimeType)));
        }
        catch (IOException exception) {
            log.error("failed to detect mime-type for the file, ignoring {}", (Object)value);
        }
    }

    private boolean isFile(String value) {
        boolean fileExists;
        try {
            fileExists = Files.exists(Paths.get(value, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException ex) {
            fileExists = false;
        }
        return fileExists;
    }

    static {
        TIKA = new Tika();
        om = new ObjectMapper();
        String version = RequestHandler.class.getPackage().getImplementationVersion();
        USER_AGENT_HEADER_VALUE = String.format("hyperscience-saas-client-java/%s", version);
    }
}

