/*
 * Decompiled with CFR 0.152.
 */
package com.hyperscience.saas.auth.model;

import java.util.Base64;

public abstract class Credentials {
    private final String clientId;
    private final String clientSecret;

    public Credentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    private static String decodeBase64String(String b64Str) {
        String paddedB64 = Credentials.padBase64String(b64Str);
        return new String(Base64.getDecoder().decode(paddedB64));
    }

    private static String padBase64String(String b64Str) {
        int remainder = b64Str.length() % 4;
        StringBuilder result = new StringBuilder(b64Str);
        switch (remainder) {
            case 2: {
                result.append("==");
                break;
            }
            case 3: {
                result.append("=");
                break;
            }
        }
        return result.toString();
    }

    public String decodeClientId() {
        String decodedClientId;
        try {
            decodedClientId = Credentials.decodeBase64String(this.clientId);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("invalid client id format");
        }
        return decodedClientId;
    }

    public String decodeClientSecret() {
        if (this.clientSecret == null || this.clientSecret.isEmpty()) {
            throw new IllegalArgumentException("invalid client secret");
        }
        return this.clientSecret;
    }
}

