/*
 * Decompiled with CFR 0.152.
 */
package com.hyperscience.saas.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hyperscience.saas.config.PropertiesSingleton;
import com.hyperscience.saas.config.TimeoutConfiguration;
import com.hyperscience.saas.config.model.ConfigurationDto;
import com.hyperscience.saas.config.model.TimeoutConfigurationDto;
import com.hyperscience.saas.errors.ConfigurationLoadException;
import com.hyperscience.saas.utils.Validator;
import java.io.File;
import java.io.IOException;

public class Configuration {
    private static final ObjectMapper om = new ObjectMapper();
    private final String hyperscienceDomain;
    private final String authServer;
    private TimeoutConfiguration timeOutConfiguration;

    public Configuration(String hyperscienceDomain) {
        this.hyperscienceDomain = hyperscienceDomain;
        this.authServer = PropertiesSingleton.getSaasClientProperties().getProperty("auth_server");
        this.timeOutConfiguration = TimeoutConfiguration.getDefaultTimeoutConfiguration();
    }

    public Configuration(String hyperscienceDomain, String authServer) {
        this.hyperscienceDomain = hyperscienceDomain;
        this.authServer = authServer;
        this.timeOutConfiguration = TimeoutConfiguration.getDefaultTimeoutConfiguration();
    }

    public Configuration(String hyperscienceDomain, TimeoutConfiguration timeoutConfiguration) {
        this.hyperscienceDomain = hyperscienceDomain;
        this.authServer = PropertiesSingleton.getSaasClientProperties().getProperty("auth_server");
        this.timeOutConfiguration = timeoutConfiguration != null ? timeoutConfiguration : TimeoutConfiguration.getDefaultTimeoutConfiguration();
    }

    public Configuration(String hyperscienceDomain, String authServer, TimeoutConfiguration timeoutConfiguration) {
        this.hyperscienceDomain = hyperscienceDomain;
        this.authServer = authServer;
        this.timeOutConfiguration = timeoutConfiguration != null ? timeoutConfiguration : TimeoutConfiguration.getDefaultTimeoutConfiguration();
    }

    public Configuration(ConfigurationDto configurationDto) {
        String authServer = configurationDto.getAuthServer();
        this.authServer = authServer != null ? authServer : PropertiesSingleton.getSaasClientProperties().getProperty("auth_server");
        this.hyperscienceDomain = configurationDto.getHyperscienceDomain();
        TimeoutConfigurationDto timeoutConfigurationDto = configurationDto.getTimeoutConfiguration();
        if (timeoutConfigurationDto != null) {
            this.timeOutConfiguration = new TimeoutConfiguration(timeoutConfigurationDto.getConnectionTimeout(), timeoutConfigurationDto.getReadTimeout());
        }
        Configuration.validate(this);
    }

    public static Configuration fromFile(String path) throws ConfigurationLoadException {
        ConfigurationDto configurationDto;
        File file = new File(path);
        try {
            configurationDto = (ConfigurationDto)om.readValue(file, ConfigurationDto.class);
        }
        catch (IOException ex) {
            throw new ConfigurationLoadException("Failed to load configuration from file", ex);
        }
        return new Configuration(configurationDto);
    }

    public static Configuration fromJsonString(String json) throws ConfigurationLoadException {
        ConfigurationDto configurationDto;
        try {
            configurationDto = (ConfigurationDto)om.readValue(json, ConfigurationDto.class);
        }
        catch (JsonProcessingException ex) {
            throw new ConfigurationLoadException("Failed to load configuration from string", ex);
        }
        return new Configuration(configurationDto);
    }

    private static void validate(Configuration configuration) {
        Validator.validateNotEmpty(configuration.authServer, "auth_server is required!");
        Validator.validateNotEmpty(configuration.hyperscienceDomain, "hs_domain is required!");
        Validator.validateGreaterThanZero(configuration.getTimeOutConfiguration().getConnectionTimeout(), "connection_timeout should be greater than 0!");
        Validator.validateGreaterThanZero(configuration.getTimeOutConfiguration().getReadTimeout(), "read_timeout should be greater than 0!");
    }

    public TimeoutConfiguration getTimeOutConfiguration() {
        return this.timeOutConfiguration != null ? this.timeOutConfiguration : TimeoutConfiguration.getDefaultTimeoutConfiguration();
    }

    public String getHyperscienceDomain() {
        return this.hyperscienceDomain;
    }

    public String getAuthServer() {
        return this.authServer;
    }
}

