/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk;

import com.fasterxml.jackson.core.type.TypeReference;
import com.hyperwallet.clientsdk.HyperwalletException;
import com.hyperwallet.clientsdk.model.HyperwalletAccount;
import com.hyperwallet.clientsdk.model.HyperwalletAuthenticationToken;
import com.hyperwallet.clientsdk.model.HyperwalletBalance;
import com.hyperwallet.clientsdk.model.HyperwalletBalanceListOptions;
import com.hyperwallet.clientsdk.model.HyperwalletBankAccount;
import com.hyperwallet.clientsdk.model.HyperwalletBankAccountsListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletBankCard;
import com.hyperwallet.clientsdk.model.HyperwalletBankCardListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletBusinessStakeholder;
import com.hyperwallet.clientsdk.model.HyperwalletList;
import com.hyperwallet.clientsdk.model.HyperwalletPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletPaperCheck;
import com.hyperwallet.clientsdk.model.HyperwalletPaperCheckListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletPayPalAccount;
import com.hyperwallet.clientsdk.model.HyperwalletPayPalAccountListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletPayment;
import com.hyperwallet.clientsdk.model.HyperwalletPaymentListOptions;
import com.hyperwallet.clientsdk.model.HyperwalletPrepaidCard;
import com.hyperwallet.clientsdk.model.HyperwalletPrepaidCardListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletProgram;
import com.hyperwallet.clientsdk.model.HyperwalletReceipt;
import com.hyperwallet.clientsdk.model.HyperwalletReceiptPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletStatusTransition;
import com.hyperwallet.clientsdk.model.HyperwalletStatusTransitionListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletTransfer;
import com.hyperwallet.clientsdk.model.HyperwalletTransferListOptions;
import com.hyperwallet.clientsdk.model.HyperwalletTransferMethod;
import com.hyperwallet.clientsdk.model.HyperwalletTransferMethodConfiguration;
import com.hyperwallet.clientsdk.model.HyperwalletTransferMethodListOptions;
import com.hyperwallet.clientsdk.model.HyperwalletTransferRefund;
import com.hyperwallet.clientsdk.model.HyperwalletTransferRefundListOptions;
import com.hyperwallet.clientsdk.model.HyperwalletUser;
import com.hyperwallet.clientsdk.model.HyperwalletUsersListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletVenmoAccount;
import com.hyperwallet.clientsdk.model.HyperwalletVenmoAccountListPaginationOptions;
import com.hyperwallet.clientsdk.model.HyperwalletVerificationDocument;
import com.hyperwallet.clientsdk.model.HyperwalletWebhookNotification;
import com.hyperwallet.clientsdk.model.HyperwalletWebhookNotificationPaginationOptions;
import com.hyperwallet.clientsdk.util.HyperwalletApiClient;
import com.hyperwallet.clientsdk.util.HyperwalletEncryption;
import com.hyperwallet.clientsdk.util.HyperwalletJsonUtil;
import com.hyperwallet.clientsdk.util.HyperwalletMultipartUtils;
import com.hyperwallet.clientsdk.util.Multipart;
import java.io.IOException;
import java.net.Proxy;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class Hyperwallet {
    private static final String SANDBOX_API_BASE = "https://api.sandbox.hyperwallet.com/rest/v4";
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    public static final String VERSION = "2.4.3";
    private final HyperwalletApiClient apiClient;
    private final String programToken;
    private final String url;

    public Hyperwallet(String username, String password, String programToken, String server, HyperwalletEncryption hyperwalletEncryption, int connectionTimeout, int readTimeout) {
        this.apiClient = new HyperwalletApiClient(username, password, VERSION, hyperwalletEncryption, connectionTimeout, readTimeout);
        this.programToken = programToken;
        this.url = StringUtils.isEmpty((CharSequence)server) ? SANDBOX_API_BASE : server + "/rest/v4";
    }

    public Hyperwallet(String username, String password, String programToken, String server, HyperwalletEncryption hyperwalletEncryption) {
        this(username, password, programToken, server, hyperwalletEncryption, 30000, 30000);
    }

    public Hyperwallet(String username, String password, String programToken, String server, int connectionTimeout, int readTimeout) {
        this(username, password, programToken, server, null, connectionTimeout, readTimeout);
    }

    public Hyperwallet(String username, String password, String programToken, String server) {
        this(username, password, programToken, server, null);
    }

    public Hyperwallet(String username, String password, String programToken, int connectionTimeout, int readTimeout) {
        this(username, password, programToken, null, null, connectionTimeout, readTimeout);
    }

    public Hyperwallet(String username, String password, String programToken) {
        this(username, password, programToken, null, null);
    }

    public Hyperwallet(String username, String password, String programToken, HyperwalletEncryption hyperwalletEncryption) {
        this(username, password, programToken, null, hyperwalletEncryption);
    }

    public Hyperwallet(String username, String password) {
        this(username, password, null);
    }

    public void setHyperwalletProxy(String url, Integer port) {
        this.apiClient.setProxy(url, port);
    }

    public void setHyperwalletProxy(Proxy proxy) {
        this.apiClient.setProxy(proxy);
    }

    public Proxy getHyperwalletProxy() {
        return this.apiClient.getProxy();
    }

    public Boolean usesHyperwalletProxy() {
        return this.apiClient.usesProxy();
    }

    public void setHyperwalletProxyUsername(String proxyUsername) {
        this.apiClient.setProxyUsername(proxyUsername);
    }

    public String getHyperwalletProxyUsername() {
        return this.apiClient.getProxyUsername();
    }

    public void setHyperwalletProxyPassword(String proxyPassword) {
        this.apiClient.setProxyPassword(proxyPassword);
    }

    public String getHyperwalletProxyPassword() {
        return this.apiClient.getProxyPassword();
    }

    public HyperwalletUser createUser(HyperwalletUser user) {
        if (user == null) {
            throw new HyperwalletException("User is required");
        }
        if (!StringUtils.isEmpty((CharSequence)user.getToken())) {
            throw new HyperwalletException("User token may not be present");
        }
        user = this.copy(user);
        user.setStatus(null);
        user.setCreatedOn(null);
        return this.apiClient.post(this.url + "/users", user, HyperwalletUser.class);
    }

    public HyperwalletUser getUser(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new HyperwalletException("User token is required");
        }
        return this.apiClient.get(this.url + "/users/" + token, HyperwalletUser.class);
    }

    public HyperwalletUser updateUser(HyperwalletUser user) {
        if (user == null) {
            throw new HyperwalletException("User is required");
        }
        if (StringUtils.isEmpty((CharSequence)user.getToken())) {
            throw new HyperwalletException("User token is required");
        }
        return this.apiClient.put(this.url + "/users/" + user.getToken(), user, HyperwalletUser.class);
    }

    public HyperwalletList<HyperwalletUser> listUsers() {
        return this.listUsers(null);
    }

    public HyperwalletList<HyperwalletUser> listUsers(HyperwalletUsersListPaginationOptions options) {
        String url = this.paginate(this.url + "/users", options);
        if (options != null) {
            url = this.addParameter(url, "clientUserId", options.getClientUserId());
            url = this.addParameter(url, "email", options.getEmail());
            url = this.addParameter(url, "programToken", options.getProgramToken());
            url = this.addParameter(url, "status", (Object)options.getStatus());
            url = this.addParameter(url, "verificationStatus", (Object)options.getVerificationStatus());
            url = this.addParameter(url, "taxVerificationStatus", (Object)options.getTaxVerificationStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletUser>>(){});
    }

    public HyperwalletBusinessStakeholder createBusinessStakeholder(String userToken, HyperwalletBusinessStakeholder stakeholder) {
        if (stakeholder == null) {
            throw new HyperwalletException("Stakeholder is required");
        }
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        stakeholder = this.copy(stakeholder);
        return this.apiClient.post(this.url + "/users/" + userToken + "/business-stakeholders", stakeholder, HyperwalletBusinessStakeholder.class);
    }

    public HyperwalletBusinessStakeholder updateBusinessStakeholder(String userToken, HyperwalletBusinessStakeholder stakeholder) {
        if (stakeholder == null) {
            throw new HyperwalletException("Stakeholder is required");
        }
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (stakeholder.getToken() == null || stakeholder.getToken().equals("")) {
            throw new HyperwalletException("Stakeholder token may not be present");
        }
        stakeholder = this.copy(stakeholder);
        return this.apiClient.put(this.url + "/users/" + userToken + "/business-stakeholders/" + stakeholder.getToken(), stakeholder, HyperwalletBusinessStakeholder.class);
    }

    public HyperwalletList<HyperwalletBusinessStakeholder> listBusinessStakeholders(String userToken) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        return this.listBusinessStakeholders(userToken, null);
    }

    public HyperwalletList<HyperwalletBusinessStakeholder> listBusinessStakeholders(String userToken, HyperwalletPaginationOptions options) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/business-stakeholders", options);
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBusinessStakeholder>>(){});
    }

    public HyperwalletBusinessStakeholder uploadStakeholderDocuments(String userToken, String businessStakeholderToken, List<HyperwalletVerificationDocument> uploadData) {
        Multipart multipart = new Multipart();
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (businessStakeholderToken == null) {
            throw new HyperwalletException("BusinessStakeholderToken may not be present");
        }
        if (uploadData == null || uploadData.size() < 1) {
            throw new HyperwalletException("Data for upload is missing");
        }
        if (uploadData.get(0).getUploadFiles() == null || uploadData.get(0).getUploadFiles().size() < 1) {
            throw new HyperwalletException("Upload Files are missing");
        }
        try {
            multipart = HyperwalletMultipartUtils.convert(uploadData);
        }
        catch (IOException e) {
            throw new HyperwalletException("Unable to convert to Multipart formdata");
        }
        return this.apiClient.put(this.url + "/users/" + userToken + "/business-stakeholders/" + businessStakeholderToken, multipart, HyperwalletBusinessStakeholder.class);
    }

    public HyperwalletStatusTransition createBusinessStakeholderStatusTransition(String userToken, String stakeholderToken, HyperwalletStatusTransition transition) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (stakeholderToken == null) {
            throw new HyperwalletException("StakeholderToken is required");
        }
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/business-stakeholders/" + stakeholderToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getBusinessStakeholderStatusTransition(String userToken, String stakeholderToken, String statusTransitionToken) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (stakeholderToken == null) {
            throw new HyperwalletException("StakeholderToken is required");
        }
        if (statusTransitionToken == null) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/business-stakeholders/" + stakeholderToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listBusinessStakeholderStatusTransition(String userToken, String stakeholderToken, HyperwalletPaginationOptions options) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (stakeholderToken == null) {
            throw new HyperwalletException("StakeholderToken is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/business-stakeholders/" + stakeholderToken + "/status-transitions", options);
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletList<HyperwalletStatusTransition> listBusinessStakeholderStatusTransition(String userToken, String stakeholderToken) {
        return this.listBusinessStakeholderStatusTransition(userToken, stakeholderToken, null);
    }

    public HyperwalletStatusTransition activateBusinessStakeholder(String userToken, String stakeholderToken) {
        return this.createBusinessStakeholderStatusTransition(userToken, stakeholderToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.ACTIVATED));
    }

    public HyperwalletStatusTransition deactivateBusinessStakeholder(String userToken, String stakeholderToken) {
        return this.createBusinessStakeholderStatusTransition(userToken, stakeholderToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED));
    }

    public HyperwalletAuthenticationToken getAuthenticationToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new HyperwalletException("User token is required");
        }
        String urlString = this.url + "/users/" + token + "/authentication-token";
        return this.apiClient.post(urlString, null, HyperwalletAuthenticationToken.class);
    }

    public HyperwalletStatusTransition getUserStatusTransition(String userToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listUserStatusTransitions(String userToken) {
        return this.listUserStatusTransitions(userToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listUserStatusTransitions(String userToken, HyperwalletPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/status-transitions", options);
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletStatusTransition createUserStatusTransition(String userToken, HyperwalletStatusTransition transition) {
        if (userToken == null) {
            throw new HyperwalletException("User token may not be present");
        }
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition activateUser(String userToken) {
        return this.createUserStatusTransition(userToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.ACTIVATED));
    }

    public HyperwalletStatusTransition deactivateUser(String userToken) {
        return this.createUserStatusTransition(userToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED));
    }

    public HyperwalletStatusTransition lockUser(String userToken) {
        return this.createUserStatusTransition(userToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.LOCKED));
    }

    public HyperwalletStatusTransition freezeUser(String userToken) {
        return this.createUserStatusTransition(userToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.FROZEN));
    }

    public HyperwalletStatusTransition preactivateUser(String userToken) {
        return this.createUserStatusTransition(userToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.PRE_ACTIVATED));
    }

    public HyperwalletPrepaidCard createOrReplacePrepaidCard(HyperwalletPrepaidCard prepaidCard) {
        if (prepaidCard == null) {
            throw new HyperwalletException("Prepaid Card is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCard.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)prepaidCard.getToken())) {
            throw new HyperwalletException("Prepaid Card token may not be present");
        }
        if (prepaidCard.getType() == null) {
            prepaidCard.setType(HyperwalletPrepaidCard.Type.PREPAID_CARD);
        }
        prepaidCard = this.copy(prepaidCard);
        prepaidCard.setStatus(null);
        prepaidCard.setCardType(null);
        prepaidCard.setCreatedOn(null);
        prepaidCard.setTransferMethodCountry(null);
        prepaidCard.setTransferMethodCurrency(null);
        prepaidCard.setCardNumber(null);
        prepaidCard.setCardBrand(null);
        prepaidCard.setDateOfExpiry(null);
        return this.apiClient.post(this.url + "/users/" + prepaidCard.getUserToken() + "/prepaid-cards", prepaidCard, HyperwalletPrepaidCard.class);
    }

    public HyperwalletPrepaidCard getPrepaidCard(String userToken, String prepaidCardToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken, HyperwalletPrepaidCard.class);
    }

    public HyperwalletPrepaidCard updatePrepaidCard(HyperwalletPrepaidCard prepaidCard) {
        if (prepaidCard == null) {
            throw new HyperwalletException("Prepaid Card is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCard.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCard.getToken())) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        return this.apiClient.put(this.url + "/users/" + prepaidCard.getUserToken() + "/prepaid-cards/" + prepaidCard.getToken(), prepaidCard, HyperwalletPrepaidCard.class);
    }

    public HyperwalletList<HyperwalletPrepaidCard> listPrepaidCards(String userToken) {
        return this.listPrepaidCards(userToken, null);
    }

    public HyperwalletList<HyperwalletPrepaidCard> listPrepaidCards(String userToken, HyperwalletPrepaidCardListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/prepaid-cards", options);
        if (options != null && options.getStatus() != null) {
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletPrepaidCard>>(){});
    }

    public HyperwalletStatusTransition suspendPrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.SUSPENDED));
    }

    public HyperwalletStatusTransition unsuspendPrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.UNSUSPENDED));
    }

    public HyperwalletStatusTransition lostOrStolenPrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.LOST_OR_STOLEN));
    }

    public HyperwalletStatusTransition deactivatePrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED));
    }

    public HyperwalletStatusTransition lockPrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.LOCKED));
    }

    public HyperwalletStatusTransition unlockPrepaidCard(String userToken, String prepaidCardToken) {
        return this.createPrepaidCardStatusTransition(userToken, prepaidCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.UNLOCKED));
    }

    public HyperwalletStatusTransition createPrepaidCardStatusTransition(String userToken, String prepaidCardToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getPrepaidCardStatusTransition(String userToken, String prepaidCardToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPrepaidCardStatusTransitions(String userToken, String prepaidCardToken) {
        return this.listPrepaidCardStatusTransitions(userToken, prepaidCardToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPrepaidCardStatusTransitions(String userToken, String prepaidCardToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken + "/status-transitions", options);
        if (options != null && options.getTransition() != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletBankCard createBankCard(HyperwalletBankCard bankCard) {
        if (bankCard == null) {
            throw new HyperwalletException("Bank Card is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCard.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)bankCard.getToken())) {
            throw new HyperwalletException("Bank Card token may not be present");
        }
        if (bankCard.getType() == null) {
            bankCard.setType(HyperwalletBankCard.Type.BANK_CARD);
        }
        bankCard = this.copy(bankCard);
        bankCard.setStatus(null);
        bankCard.setCardType(null);
        bankCard.setCreatedOn(null);
        bankCard.setCardBrand(null);
        return this.apiClient.post(this.url + "/users/" + bankCard.getUserToken() + "/bank-cards", bankCard, HyperwalletBankCard.class);
    }

    public HyperwalletBankCard getBankCard(String userToken, String bankCardToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCardToken)) {
            throw new HyperwalletException("Bank Card token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/bank-cards/" + bankCardToken, HyperwalletBankCard.class);
    }

    public HyperwalletBankCard updateBankCard(HyperwalletBankCard bankCard) {
        if (bankCard == null) {
            throw new HyperwalletException("Bank Card is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCard.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCard.getToken())) {
            throw new HyperwalletException("Bank Card token is required");
        }
        return this.apiClient.put(this.url + "/users/" + bankCard.getUserToken() + "/bank-cards/" + bankCard.getToken(), bankCard, HyperwalletBankCard.class);
    }

    public HyperwalletList<HyperwalletBankCard> listBankCards(String userToken) {
        return this.listBankCards(userToken, null);
    }

    public HyperwalletList<HyperwalletBankCard> listBankCards(String userToken, HyperwalletBankCardListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/bank-cards", options);
        if (options != null) {
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBankCard>>(){});
    }

    public HyperwalletStatusTransition deactivateBankCard(String userToken, String bankCardToken) {
        return this.deactivateBankCard(userToken, bankCardToken, null);
    }

    public HyperwalletStatusTransition deactivateBankCard(String userToken, String bankCardToken, String notes) {
        return this.createBankCardStatusTransition(userToken, bankCardToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED).notes(notes));
    }

    public HyperwalletStatusTransition createBankCardStatusTransition(String userToken, String bankCardToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCardToken)) {
            throw new HyperwalletException("Bank Card token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/bank-cards/" + bankCardToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getBankCardStatusTransition(String userToken, String bankCardToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCardToken)) {
            throw new HyperwalletException("Bank Card token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/bank-cards/" + bankCardToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listBankCardStatusTransitions(String userToken, String bankCardToken) {
        return this.listBankCardStatusTransitions(userToken, bankCardToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listBankCardStatusTransitions(String userToken, String bankCardToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankCardToken)) {
            throw new HyperwalletException("Bank Card token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/bank-cards/" + bankCardToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletPaperCheck createPaperCheck(HyperwalletPaperCheck paperCheck) {
        if (paperCheck == null) {
            throw new HyperwalletException("Paper Check is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheck.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)paperCheck.getToken())) {
            throw new HyperwalletException("Paper Check token may not be present");
        }
        if (paperCheck.getType() == null) {
            paperCheck.setType(HyperwalletPaperCheck.Type.PAPER_CHECK);
        }
        paperCheck = this.copy(paperCheck);
        paperCheck.setStatus(null);
        paperCheck.setCreatedOn(null);
        return this.apiClient.post(this.url + "/users/" + paperCheck.getUserToken() + "/paper-checks", paperCheck, HyperwalletPaperCheck.class);
    }

    public HyperwalletPaperCheck getPaperCheck(String userToken, String paperCheckToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheckToken)) {
            throw new HyperwalletException("Paper Check token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/paper-checks/" + paperCheckToken, HyperwalletPaperCheck.class);
    }

    public HyperwalletPaperCheck updatePaperCheck(HyperwalletPaperCheck paperCheck) {
        if (paperCheck == null) {
            throw new HyperwalletException("Paper Check is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheck.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheck.getToken())) {
            throw new HyperwalletException("Paper Check token is required");
        }
        return this.apiClient.put(this.url + "/users/" + paperCheck.getUserToken() + "/paper-checks/" + paperCheck.getToken(), paperCheck, HyperwalletPaperCheck.class);
    }

    public HyperwalletList<HyperwalletPaperCheck> listPaperChecks(String userToken) {
        return this.listPaperChecks(userToken, null);
    }

    public HyperwalletList<HyperwalletPaperCheck> listPaperChecks(String userToken, HyperwalletPaperCheckListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/paper-checks", options);
        if (options != null) {
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletPaperCheck>>(){});
    }

    public HyperwalletStatusTransition deactivatePaperCheck(String userToken, String paperCheckToken) {
        return this.deactivatePaperCheck(userToken, paperCheckToken, null);
    }

    public HyperwalletStatusTransition deactivatePaperCheck(String userToken, String paperCheckToken, String notes) {
        return this.createPaperCheckStatusTransition(userToken, paperCheckToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED).notes(notes));
    }

    public HyperwalletStatusTransition createPaperCheckStatusTransition(String userToken, String paperCheckToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheckToken)) {
            throw new HyperwalletException("Paper Check token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/paper-checks/" + paperCheckToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getPaperCheckStatusTransition(String userToken, String paperCheckToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheckToken)) {
            throw new HyperwalletException("Paper Check token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/paper-checks/" + paperCheckToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPaperCheckStatusTransitions(String userToken, String paperCheckToken) {
        return this.listPaperCheckStatusTransitions(userToken, paperCheckToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPaperCheckStatusTransitions(String userToken, String paperCheckToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)paperCheckToken)) {
            throw new HyperwalletException("Paper Check token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/paper-checks/" + paperCheckToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletTransfer createTransfer(HyperwalletTransfer transfer) {
        if (transfer == null) {
            throw new HyperwalletException("Transfer is required");
        }
        if (StringUtils.isEmpty((CharSequence)transfer.getSourceToken())) {
            throw new HyperwalletException("Source token is required");
        }
        if (StringUtils.isEmpty((CharSequence)transfer.getDestinationToken())) {
            throw new HyperwalletException("Destination token is required");
        }
        if (StringUtils.isEmpty((CharSequence)transfer.getClientTransferId())) {
            throw new HyperwalletException("ClientTransferId is required");
        }
        transfer = this.copy(transfer);
        transfer.setStatus(null);
        transfer.setCreatedOn(null);
        transfer.setExpiresOn(null);
        return this.apiClient.post(this.url + "/transfers", transfer, HyperwalletTransfer.class);
    }

    public HyperwalletTransfer getTransfer(String transferToken) {
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        return this.apiClient.get(this.url + "/transfers/" + transferToken, HyperwalletTransfer.class);
    }

    public HyperwalletList<HyperwalletTransfer> listTransfers(HyperwalletTransferListOptions options) {
        String url = this.paginate(this.url + "/transfers", options);
        if (options != null) {
            url = this.addParameter(url, "clientTransferId", options.getClientTransferId());
            url = this.addParameter(url, "sourceToken", options.getSourceToken());
            url = this.addParameter(url, "destinationToken", options.getDestinationToken());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletTransfer>>(){});
    }

    public HyperwalletList<HyperwalletTransfer> listTransfers() {
        return this.listTransfers(null);
    }

    public HyperwalletStatusTransition createTransferStatusTransition(String transferToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/transfers/" + transferToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getTransferStatusTransition(String transferToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("statusTransitionToken is required");
        }
        return this.apiClient.get(this.url + "/transfers/" + transferToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listTransferStatusTransition(String transferToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        String url = this.paginate(this.url + "/transfers/" + transferToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletTransferRefund createTransferRefund(String transferToken, HyperwalletTransferRefund transferRefund) {
        if (transferRefund == null) {
            throw new HyperwalletException("Transfer Refund is required");
        }
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        if (StringUtils.isEmpty((CharSequence)transferRefund.getClientRefundId())) {
            throw new HyperwalletException("ClientRefundId is required");
        }
        transferRefund = this.copy(transferRefund);
        transferRefund.clearStatus();
        transferRefund.clearCreatedOn();
        return this.apiClient.post(this.url + "/transfers/" + transferToken + "/refunds", transferRefund, HyperwalletTransferRefund.class);
    }

    public HyperwalletTransferRefund getTransferRefund(String transferToken, String transferRefundToken) {
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        if (StringUtils.isEmpty((CharSequence)transferRefundToken)) {
            throw new HyperwalletException("Transfer Refund token is required");
        }
        return this.apiClient.get(this.url + "/transfers/" + transferToken + "/refunds/" + transferRefundToken, HyperwalletTransferRefund.class);
    }

    public HyperwalletList<HyperwalletTransferRefund> listTransferRefunds(String transferToken, HyperwalletTransferRefundListOptions options) {
        if (StringUtils.isEmpty((CharSequence)transferToken)) {
            throw new HyperwalletException("Transfer token is required");
        }
        String url = this.paginate(this.url + "/transfers/" + transferToken + "/refunds", options);
        if (options != null) {
            url = this.addParameter(url, "clientRefundId", options.getClientRefundId());
            url = this.addParameter(url, "sourceToken", options.getSourceToken());
            url = this.addParameter(url, "status", options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletTransferRefund>>(){});
    }

    public HyperwalletPayPalAccount createPayPalAccount(HyperwalletPayPalAccount payPalAccount) {
        if (payPalAccount == null) {
            throw new HyperwalletException("PayPal Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getTransferMethodCountry())) {
            throw new HyperwalletException("Transfer Method Country is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getTransferMethodCurrency())) {
            throw new HyperwalletException("Transfer Method Currency is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getEmail()) && StringUtils.isEmpty((CharSequence)payPalAccount.getAccountId())) {
            throw new HyperwalletException("Email or AccountId is required");
        }
        if (!StringUtils.isEmpty((CharSequence)payPalAccount.getToken())) {
            throw new HyperwalletException("PayPal Account token may not be present");
        }
        if (payPalAccount.getType() == null) {
            payPalAccount.setType(HyperwalletPayPalAccount.Type.PAYPAL_ACCOUNT);
        }
        payPalAccount = this.copy(payPalAccount);
        payPalAccount.setStatus(null);
        payPalAccount.setCreatedOn(null);
        return this.apiClient.post(this.url + "/users/" + payPalAccount.getUserToken() + "/paypal-accounts", payPalAccount, HyperwalletPayPalAccount.class);
    }

    public HyperwalletPayPalAccount getPayPalAccount(String userToken, String payPalAccountToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccountToken)) {
            throw new HyperwalletException("PayPal Account token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/paypal-accounts/" + payPalAccountToken, HyperwalletPayPalAccount.class);
    }

    public HyperwalletList<HyperwalletPayPalAccount> listPayPalAccounts(String userToken, HyperwalletPayPalAccountListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/paypal-accounts", options);
        if (options != null) {
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletPayPalAccount>>(){});
    }

    public HyperwalletList<HyperwalletPayPalAccount> listPayPalAccounts(String userToken) {
        return this.listPayPalAccounts(userToken, null);
    }

    public HyperwalletStatusTransition deactivatePayPalAccount(String userToken, String payPalAccountToken) {
        return this.deactivatePayPalAccount(userToken, payPalAccountToken, null);
    }

    public HyperwalletStatusTransition deactivatePayPalAccount(String userToken, String payPalAccountToken, String notes) {
        return this.createPayPalAccountStatusTransition(userToken, payPalAccountToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED).notes(notes));
    }

    public HyperwalletStatusTransition createPayPalAccountStatusTransition(String userToken, String payPalAccountToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccountToken)) {
            throw new HyperwalletException("PayPal Account token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/paypal-accounts/" + payPalAccountToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getPayPalAccountStatusTransition(String userToken, String payPalAccountToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccountToken)) {
            throw new HyperwalletException("PayPal Account token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/paypal-accounts/" + payPalAccountToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPayPalAccountStatusTransitions(String userToken, String payPalAccountToken) {
        return this.listPayPalAccountStatusTransitions(userToken, payPalAccountToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPayPalAccountStatusTransitions(String userToken, String payPalAccountToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccountToken)) {
            throw new HyperwalletException("PayPal Account token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/paypal-accounts/" + payPalAccountToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletPayPalAccount updatePayPalAccount(HyperwalletPayPalAccount payPalAccount) {
        if (payPalAccount == null) {
            throw new HyperwalletException("PayPal Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)payPalAccount.getToken())) {
            throw new HyperwalletException("PayPal Account token is required");
        }
        return this.apiClient.put(this.url + "/users/" + payPalAccount.getUserToken() + "/paypal-accounts/" + payPalAccount.getToken(), payPalAccount, HyperwalletPayPalAccount.class);
    }

    public HyperwalletVenmoAccount createVenmoAccount(HyperwalletVenmoAccount venmoAccount) {
        if (venmoAccount == null) {
            throw new HyperwalletException("Venmo Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getTransferMethodCountry())) {
            throw new HyperwalletException("Transfer Method Country is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getTransferMethodCurrency())) {
            throw new HyperwalletException("Transfer Method Currency is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getAccountId())) {
            throw new HyperwalletException("Account is required");
        }
        if (StringUtils.isNotEmpty((CharSequence)venmoAccount.getToken())) {
            throw new HyperwalletException("Venmo Account token may not be present");
        }
        if (venmoAccount.getType() == null) {
            venmoAccount.setType(HyperwalletVenmoAccount.Type.VENMO_ACCOUNT);
        }
        venmoAccount = this.copy(venmoAccount);
        venmoAccount.setStatus(null);
        venmoAccount.setCreatedOn(null);
        return this.apiClient.post(this.url + "/users/" + venmoAccount.getUserToken() + "/venmo-accounts", venmoAccount, HyperwalletVenmoAccount.class);
    }

    public HyperwalletVenmoAccount getVenmoAccount(String userToken, String venmoAccountToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccountToken)) {
            throw new HyperwalletException("venmo Account token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/venmo-accounts/" + venmoAccountToken, HyperwalletVenmoAccount.class);
    }

    public HyperwalletList<HyperwalletVenmoAccount> listVenmoAccounts(String userToken, HyperwalletVenmoAccountListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/venmo-accounts", options);
        if (options != null) {
            url = this.addParameter(url, "type", (Object)options.getType());
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletVenmoAccount>>(){});
    }

    public HyperwalletList<HyperwalletVenmoAccount> listVenmoAccounts(String userToken) {
        return this.listVenmoAccounts(userToken, null);
    }

    public HyperwalletVenmoAccount updateVenmoAccount(HyperwalletVenmoAccount venmoAccount) {
        if (venmoAccount == null) {
            throw new HyperwalletException("Venmo Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccount.getToken())) {
            throw new HyperwalletException("Venmo Account token is required");
        }
        return this.apiClient.put(this.url + "/users/" + venmoAccount.getUserToken() + "/venmo-accounts/" + venmoAccount.getToken(), venmoAccount, HyperwalletVenmoAccount.class);
    }

    public HyperwalletStatusTransition deactivateVenmoAccount(String userToken, String venmoAccountToken) {
        return this.deactivateVenmoAccount(userToken, venmoAccountToken, null);
    }

    public HyperwalletStatusTransition deactivateVenmoAccount(String userToken, String venmoAccountToken, String notes) {
        return this.createVenmoAccountStatusTransition(userToken, venmoAccountToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED).notes(notes));
    }

    public HyperwalletStatusTransition createVenmoAccountStatusTransition(String userToken, String venmoAccountToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccountToken)) {
            throw new HyperwalletException("Venmo account token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/venmo-accounts/" + venmoAccountToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getVenmoAccountStatusTransition(String userToken, String venmoAccountToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccountToken)) {
            throw new HyperwalletException("Venmo account token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/venmo-accounts/" + venmoAccountToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listVenmoAccountStatusTransitions(String userToken, String venmoAccountToken) {
        return this.listVenmoAccountStatusTransitions(userToken, venmoAccountToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listVenmoAccountStatusTransitions(String userToken, String venmoAccountToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)venmoAccountToken)) {
            throw new HyperwalletException("Venmo account token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/venmo-accounts/" + venmoAccountToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletBankAccount createBankAccount(HyperwalletBankAccount bankAccount) {
        if (bankAccount == null) {
            throw new HyperwalletException("Bank Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)bankAccount.getToken())) {
            throw new HyperwalletException("Bank Account token may not be present");
        }
        bankAccount = this.copy(bankAccount);
        bankAccount.createdOn(null);
        bankAccount.setStatus(null);
        return this.apiClient.post(this.url + "/users/" + bankAccount.getUserToken() + "/bank-accounts", bankAccount, HyperwalletBankAccount.class);
    }

    public HyperwalletBankAccount getBankAccount(String userToken, String transferMethodToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)transferMethodToken)) {
            throw new HyperwalletException("Bank Account token is required");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/bank-accounts/" + transferMethodToken, HyperwalletBankAccount.class);
    }

    public HyperwalletBankAccount updateBankAccount(HyperwalletBankAccount bankAccount) {
        if (bankAccount == null) {
            throw new HyperwalletException("Bank Account is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccount.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccount.getToken())) {
            throw new HyperwalletException("Bank Account token is required");
        }
        return this.apiClient.put(this.url + "/users/" + bankAccount.getUserToken() + "/bank-accounts/" + bankAccount.getToken(), bankAccount, HyperwalletBankAccount.class);
    }

    public HyperwalletList<HyperwalletBankAccount> listBankAccounts(String userToken) {
        return this.listBankAccounts(userToken, null);
    }

    public HyperwalletList<HyperwalletBankAccount> listBankAccounts(String userToken, HyperwalletBankAccountsListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/bank-accounts", options);
        if (options != null) {
            url = this.addParameter(url, "type", (Object)options.getType());
            url = this.addParameter(url, "status", (Object)options.getStatus());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBankAccount>>(){});
    }

    public HyperwalletStatusTransition deactivateBankAccount(String userToken, String bankAccountToken) {
        return this.createBankAccountStatusTransition(userToken, bankAccountToken, new HyperwalletStatusTransition(HyperwalletStatusTransition.Status.DE_ACTIVATED));
    }

    public HyperwalletStatusTransition createBankAccountStatusTransition(String userToken, String bankAccountToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccountToken)) {
            throw new HyperwalletException("Bank Account token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/users/" + userToken + "/bank-accounts/" + bankAccountToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getBankAccountStatusTransition(String userToken, String bankAccountToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccountToken)) {
            throw new HyperwalletException("Bank Account token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        return this.apiClient.get(this.url + "/users/" + userToken + "/bank-accounts/" + bankAccountToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listBankAccountStatusTransitions(String userToken, String bankAccountToken) {
        return this.listBankAccountStatusTransitions(userToken, bankAccountToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listBankAccountStatusTransitions(String userToken, String bankAccountToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)bankAccountToken)) {
            throw new HyperwalletException("Bank Account token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/bank-accounts/" + bankAccountToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForUser(String userToken) {
        return this.listBalancesForUser(userToken, null);
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForUser(String userToken, HyperwalletBalanceListOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.url + "/users/" + userToken + "/balances";
        if (options != null) {
            url = this.addParameter(url, "currency", options.getCurrency());
            url = this.addParameter(url, "sortBy", options.getSortBy());
            url = this.addParameter(url, "limit", options.getLimit());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBalance>>(){});
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForAccount(String programToken, String accountToken) {
        return this.listBalancesForAccount(programToken, accountToken, null);
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForAccount(String programToken, String accountToken, HyperwalletBalanceListOptions options) {
        if (StringUtils.isEmpty((CharSequence)programToken)) {
            throw new HyperwalletException("Program token is required");
        }
        if (StringUtils.isEmpty((CharSequence)accountToken)) {
            throw new HyperwalletException("Account token is required");
        }
        String url = this.url + "/programs/" + programToken + "/accounts/" + accountToken + "/balances";
        if (options != null) {
            url = this.addParameter(url, "currency", options.getCurrency());
            url = this.addParameter(url, "sortBy", options.getSortBy());
            url = this.addParameter(url, "limit", options.getLimit());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBalance>>(){});
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForPrepaidCard(String userToken, String prepaidCardToken) {
        return this.listBalancesForPrepaidCard(userToken, prepaidCardToken, null);
    }

    public HyperwalletList<HyperwalletBalance> listBalancesForPrepaidCard(String userToken, String prepaidCardToken, HyperwalletBalanceListOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid Card token is required");
        }
        String url = this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken + "/balances";
        if (options != null) {
            url = this.addParameter(url, "sortBy", options.getSortBy());
            url = this.addParameter(url, "limit", options.getLimit());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletBalance>>(){});
    }

    public HyperwalletPayment createPayment(HyperwalletPayment payment) {
        if (payment == null) {
            throw new HyperwalletException("Payment is required");
        }
        if (!StringUtils.isEmpty((CharSequence)payment.getToken())) {
            throw new HyperwalletException("Payment token may not be present");
        }
        payment = this.copy(payment);
        payment.setCreatedOn(null);
        return this.apiClient.post(this.url + "/payments", payment, HyperwalletPayment.class);
    }

    public HyperwalletPayment getPayment(String paymentToken) {
        if (StringUtils.isEmpty((CharSequence)paymentToken)) {
            throw new HyperwalletException("Payment token is required");
        }
        return this.apiClient.get(this.url + "/payments/" + paymentToken, HyperwalletPayment.class);
    }

    public HyperwalletList<HyperwalletPayment> listPayments() {
        return this.listPayments(null);
    }

    public HyperwalletList<HyperwalletPayment> listPayments(HyperwalletPaymentListOptions options) {
        String url = this.paginate(this.url + "/payments", options);
        if (options != null) {
            url = this.addParameter(url, "clientPaymentId", options.getClientPaymentId());
            url = this.addParameter(url, "releaseDate", this.convert(options.getReleaseDate()));
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletPayment>>(){});
    }

    public HyperwalletStatusTransition createPaymentStatusTransition(String paymentToken, HyperwalletStatusTransition transition) {
        if (transition == null) {
            throw new HyperwalletException("Transition is required");
        }
        if (StringUtils.isEmpty((CharSequence)paymentToken)) {
            throw new HyperwalletException("Payment token is required");
        }
        if (!StringUtils.isEmpty((CharSequence)transition.getToken())) {
            throw new HyperwalletException("Status Transition token may not be present");
        }
        transition = this.copy(transition);
        transition.setCreatedOn(null);
        transition.setFromStatus(null);
        transition.setToStatus(null);
        return this.apiClient.post(this.url + "/payments/" + paymentToken + "/status-transitions", transition, HyperwalletStatusTransition.class);
    }

    public HyperwalletStatusTransition getPaymentStatusTransition(String paymentToken, String statusTransitionToken) {
        if (StringUtils.isEmpty((CharSequence)paymentToken)) {
            throw new HyperwalletException("Payment token is required");
        }
        if (StringUtils.isEmpty((CharSequence)statusTransitionToken)) {
            throw new HyperwalletException("Transition token is required");
        }
        return this.apiClient.get(this.url + "/payments/" + paymentToken + "/status-transitions/" + statusTransitionToken, HyperwalletStatusTransition.class);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPaymentStatusTransitions(String paymentToken) {
        return this.listPaymentStatusTransitions(paymentToken, null);
    }

    public HyperwalletList<HyperwalletStatusTransition> listPaymentStatusTransitions(String paymentToken, HyperwalletStatusTransitionListPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)paymentToken)) {
            throw new HyperwalletException("Payment token is required");
        }
        String url = this.paginate(this.url + "/payments/" + paymentToken + "/status-transitions", options);
        if (options != null) {
            url = this.addParameter(url, "transition", (Object)options.getTransition());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletStatusTransition>>(){});
    }

    public HyperwalletProgram getProgram(String programToken) {
        if (StringUtils.isEmpty((CharSequence)programToken)) {
            throw new HyperwalletException("Program token is required");
        }
        return this.apiClient.get(this.url + "/programs/" + programToken, HyperwalletProgram.class);
    }

    public HyperwalletAccount getProgramAccount(String programToken, String accountToken) {
        if (StringUtils.isEmpty((CharSequence)programToken)) {
            throw new HyperwalletException("Program token is required");
        }
        if (StringUtils.isEmpty((CharSequence)accountToken)) {
            throw new HyperwalletException("Account token is required");
        }
        return this.apiClient.get(this.url + "/programs/" + programToken + "/accounts/" + accountToken, HyperwalletAccount.class);
    }

    public HyperwalletTransferMethodConfiguration getTransferMethodConfiguration(String userToken, String country, String currency, HyperwalletTransferMethod.Type type, HyperwalletUser.ProfileType profileType) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)country)) {
            throw new HyperwalletException("Country is required");
        }
        if (StringUtils.isEmpty((CharSequence)currency)) {
            throw new HyperwalletException("Currency is required");
        }
        if (type == null) {
            throw new HyperwalletException("Type is required");
        }
        if (profileType == null) {
            throw new HyperwalletException("Profile Type is required");
        }
        return this.apiClient.get(this.url + "/transfer-method-configurations?userToken=" + userToken + "&country=" + country + "&currency=" + currency + "&type=" + type.name() + "&profileType=" + profileType.name(), HyperwalletTransferMethodConfiguration.class);
    }

    public HyperwalletList<HyperwalletTransferMethodConfiguration> listTransferMethodConfigurations(String userToken) {
        return this.listTransferMethodConfigurations(userToken, null);
    }

    public HyperwalletList<HyperwalletTransferMethodConfiguration> listTransferMethodConfigurations(String userToken, HyperwalletPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/transfer-method-configurations?userToken=" + userToken, options);
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletTransferMethodConfiguration>>(){});
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForProgramAccount(String programToken, String accountToken) {
        return this.listReceiptsForProgramAccount(programToken, accountToken, null);
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForProgramAccount(String programToken, String accountToken, HyperwalletReceiptPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)programToken)) {
            throw new HyperwalletException("Program token is required");
        }
        if (StringUtils.isEmpty((CharSequence)accountToken)) {
            throw new HyperwalletException("Account token is required");
        }
        String url = this.paginate(this.url + "/programs/" + programToken + "/accounts/" + accountToken + "/receipts", options);
        if (options != null && options.getType() != null) {
            url = this.addParameter(url, "type", options.getType().name());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletReceipt>>(){});
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForUser(String userToken) {
        return this.listReceiptsForUser(userToken, null);
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForUser(String userToken, HyperwalletReceiptPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/receipts", options);
        if (options != null && options.getType() != null) {
            url = this.addParameter(url, "type", options.getType().name());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletReceipt>>(){});
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForPrepaidCard(String userToken, String prepaidCardToken) {
        return this.listReceiptsForPrepaidCard(userToken, prepaidCardToken, null);
    }

    public HyperwalletList<HyperwalletReceipt> listReceiptsForPrepaidCard(String userToken, String prepaidCardToken, HyperwalletReceiptPaginationOptions options) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)prepaidCardToken)) {
            throw new HyperwalletException("Prepaid card token is required");
        }
        String url = this.paginate(this.url + "/users/" + userToken + "/prepaid-cards/" + prepaidCardToken + "/receipts", options);
        if (options != null && options.getType() != null) {
            url = this.addParameter(url, "type", options.getType().name());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletReceipt>>(){});
    }

    public HyperwalletWebhookNotification getWebhookEvent(String webhookToken) {
        if (StringUtils.isEmpty((CharSequence)webhookToken)) {
            throw new HyperwalletException("Webhook token is required");
        }
        return this.apiClient.get(this.url + "/webhook-notifications/" + webhookToken, HyperwalletWebhookNotification.class);
    }

    public HyperwalletList<HyperwalletWebhookNotification> listWebhookEvents() {
        return this.listWebhookEvents(null);
    }

    public HyperwalletList<HyperwalletWebhookNotification> listWebhookEvents(HyperwalletWebhookNotificationPaginationOptions options) {
        String url = this.paginate(this.url + "/webhook-notifications", options);
        if (options != null) {
            url = this.addParameter(url, "type", options.getType());
            url = this.addParameter(url, "programToken", options.getProgramToken());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletWebhookNotification>>(){});
    }

    public HyperwalletTransferMethod createTransferMethod(String jsonCacheToken, HyperwalletTransferMethod transferMethod) {
        if (transferMethod == null || StringUtils.isEmpty((CharSequence)transferMethod.getUserToken())) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)jsonCacheToken)) {
            throw new HyperwalletException("JSON token is required");
        }
        transferMethod = this.copy(transferMethod);
        transferMethod.setToken(null);
        transferMethod.setStatus(null);
        transferMethod.setCreatedOn(null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Json-Cache-Token", jsonCacheToken);
        return this.apiClient.post(this.url + "/users/" + transferMethod.getUserToken() + "/transfer-methods", transferMethod, HyperwalletTransferMethod.class, headers);
    }

    public HyperwalletTransferMethod createTransferMethod(String jsonCacheToken, String userToken) {
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (StringUtils.isEmpty((CharSequence)jsonCacheToken)) {
            throw new HyperwalletException("JSON token is required");
        }
        HyperwalletTransferMethod transferMethod = new HyperwalletTransferMethod();
        transferMethod.setUserToken(userToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Json-Cache-Token", jsonCacheToken);
        return this.apiClient.post(this.url + "/users/" + transferMethod.getUserToken() + "/transfer-methods", transferMethod, HyperwalletTransferMethod.class, headers);
    }

    public HyperwalletList<HyperwalletTransferMethod> listTransferMethods(String userToken, HyperwalletTransferMethodListOptions options) {
        String url = this.paginate(this.url + "/users/" + userToken + "/transfer-methods", options);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is required");
        }
        if (options != null && options.getStatus() != null) {
            url = this.addParameter(url, "status", (Object)options.getStatus());
            url = this.addParameter(url, "type", (Object)options.getType());
        }
        return this.apiClient.get(url, new TypeReference<HyperwalletList<HyperwalletTransferMethod>>(){});
    }

    public HyperwalletUser uploadUserDocuments(String userToken, List<HyperwalletVerificationDocument> uploadData) {
        Multipart multipart = new Multipart();
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            throw new HyperwalletException("User token is not present");
        }
        if (uploadData == null || uploadData.size() < 1) {
            throw new HyperwalletException("Data for upload is missing");
        }
        if (uploadData.get(0).getUploadFiles() == null || uploadData.get(0).getUploadFiles().size() < 1) {
            throw new HyperwalletException("Upload Files are missing");
        }
        try {
            multipart = HyperwalletMultipartUtils.convert(uploadData);
        }
        catch (IOException e) {
            throw new HyperwalletException("Unable to convert to Multipart formdata");
        }
        return this.apiClient.put(this.url + "/users/" + userToken, multipart, HyperwalletUser.class);
    }

    private String paginate(String url, HyperwalletPaginationOptions options) {
        if (options == null) {
            return url;
        }
        url = this.addParameter(url, "createdAfter", this.convert(options.getCreatedAfter()));
        url = this.addParameter(url, "createdBefore", this.convert(options.getCreatedBefore()));
        url = this.addParameter(url, "sortBy", options.getSortBy());
        url = this.addParameter(url, "limit", options.getLimit());
        return url;
    }

    private String addParameter(String url, String key, Object value) {
        if (url == null || key == null || value == null) {
            return url;
        }
        return url + (url.indexOf("?") == -1 ? "?" : "&") + key + "=" + value;
    }

    private String convert(Date in) {
        if (in == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(in);
    }

    private void setProgramToken(HyperwalletUser user) {
        if (user != null && user.getProgramToken() == null) {
            user.setProgramToken(this.programToken);
        }
    }

    private void setProgramToken(HyperwalletPayment payment) {
        if (payment != null && payment.getProgramToken() == null) {
            payment.setProgramToken(this.programToken);
        }
    }

    private HyperwalletUser copy(HyperwalletUser user) {
        user = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(user), HyperwalletUser.class);
        this.setProgramToken(user);
        return user;
    }

    private HyperwalletPayment copy(HyperwalletPayment payment) {
        payment = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(payment), HyperwalletPayment.class);
        this.setProgramToken(payment);
        return payment;
    }

    private HyperwalletPrepaidCard copy(HyperwalletPrepaidCard method) {
        method = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(method), HyperwalletPrepaidCard.class);
        return method;
    }

    private HyperwalletBusinessStakeholder copy(HyperwalletBusinessStakeholder method) {
        method = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(method), HyperwalletBusinessStakeholder.class);
        return method;
    }

    private HyperwalletBankCard copy(HyperwalletBankCard card) {
        card = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(card), HyperwalletBankCard.class);
        return card;
    }

    private HyperwalletPaperCheck copy(HyperwalletPaperCheck check) {
        check = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(check), HyperwalletPaperCheck.class);
        return check;
    }

    private HyperwalletBankAccount copy(HyperwalletBankAccount method) {
        method = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(method), HyperwalletBankAccount.class);
        return method;
    }

    private HyperwalletStatusTransition copy(HyperwalletStatusTransition statusTransition) {
        statusTransition = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(statusTransition), HyperwalletStatusTransition.class);
        return statusTransition;
    }

    private HyperwalletTransferMethod copy(HyperwalletTransferMethod transferMethod) {
        transferMethod = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(transferMethod), HyperwalletTransferMethod.class);
        return transferMethod;
    }

    private HyperwalletTransfer copy(HyperwalletTransfer transfer) {
        transfer = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(transfer), HyperwalletTransfer.class);
        return transfer;
    }

    private HyperwalletPayPalAccount copy(HyperwalletPayPalAccount payPalAccount) {
        payPalAccount = HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(payPalAccount), HyperwalletPayPalAccount.class);
        return payPalAccount;
    }

    private HyperwalletTransferRefund copy(HyperwalletTransferRefund transferRefund) {
        return HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(transferRefund), HyperwalletTransferRefund.class);
    }

    private HyperwalletVenmoAccount copy(HyperwalletVenmoAccount venmoAccount) {
        return HyperwalletJsonUtil.fromJson(HyperwalletJsonUtil.toJson(venmoAccount), HyperwalletVenmoAccount.class);
    }
}

