/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk;

import cc.protea.util.http.Response;
import com.hyperwallet.clientsdk.model.HyperwalletError;
import com.hyperwallet.clientsdk.model.HyperwalletErrorList;
import java.util.List;

public class HyperwalletException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Response response = null;
    private String errorMessage;
    private String errorCode;
    private List<String> relatedResources;
    private HyperwalletErrorList hyperwalletErrorList;

    public HyperwalletException(Exception e) {
        super(e);
    }

    public HyperwalletException(Response response, int code, String message) {
        super(message);
        this.response = response;
        this.errorCode = Integer.toString(code);
        this.errorMessage = message;
    }

    public HyperwalletException(Response response, int code, String message, Exception e) {
        super(e);
        this.response = response;
        this.errorCode = Integer.toString(code);
        this.errorMessage = message;
    }

    public HyperwalletException(Response response, HyperwalletErrorList hyperwalletErrorList) {
        super(hyperwalletErrorList.getErrors().get(0).getMessage());
        this.response = response;
        this.hyperwalletErrorList = hyperwalletErrorList;
        HyperwalletError error = this.hyperwalletErrorList.getErrors().get(0);
        this.errorCode = error.getCode();
        this.errorMessage = error.getMessage();
        this.relatedResources = error.getRelatedResources();
    }

    public HyperwalletException(String errorMessage) {
        super(errorMessage);
        this.errorMessage = errorMessage;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public List<String> getRelatedResources() {
        return this.relatedResources;
    }

    public List<HyperwalletError> getHyperwalletErrors() {
        return this.hyperwalletErrorList != null ? this.hyperwalletErrorList.getErrors() : null;
    }
}

