/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import cc.protea.util.http.Response;
import com.fasterxml.jackson.core.type.TypeReference;
import com.hyperwallet.clientsdk.HyperwalletException;
import com.hyperwallet.clientsdk.model.HyperwalletErrorList;
import com.hyperwallet.clientsdk.util.HyperwalletEncryption;
import com.hyperwallet.clientsdk.util.HyperwalletJsonUtil;
import com.hyperwallet.clientsdk.util.Multipart;
import com.hyperwallet.clientsdk.util.MultipartRequest;
import com.hyperwallet.clientsdk.util.Request;
import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.ParseException;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class HyperwalletApiClient {
    private static final String ACCEPT = "Accept";
    private static final String APPLICATION_JOSE_JSON = "application/jose+json";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String MULTIPART_FORM_DATA_BOUNDARY = "multipart/form-data; boundary=";
    private static final String SDK_TYPE = "java";
    private final HyperwalletEncryption hyperwalletEncryption;
    private Proxy proxy;
    private String proxyPassword;
    private String proxyUsername;
    private final String contextId;
    private final String password;
    private final String username;
    private final String version;
    private final boolean isEncrypted;
    private final int connectionTimeout;
    private final int readTimeout;

    public HyperwalletApiClient(String username, String password, String version, HyperwalletEncryption hyperwalletEncryption, int connectionTimeout, int readTimeout) {
        this.username = username;
        this.password = password;
        this.version = version;
        this.hyperwalletEncryption = hyperwalletEncryption;
        this.isEncrypted = hyperwalletEncryption != null;
        this.contextId = String.valueOf(UUID.randomUUID());
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        if (System.getProperty("java.version").startsWith("1.7.")) {
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        }
    }

    public <T> T get(String url, Class<T> type) {
        Response response = null;
        try {
            response = this.buildGetRequest(url).getResource();
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public <T> T get(String url, TypeReference<T> type) {
        Response response = null;
        try {
            response = this.buildGetRequest(url).getResource();
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public <T> T put(String url, Multipart uploadData, Class<T> type) {
        try {
            Response response = this.buildMultipartRequest(url).putMultipartResource(uploadData);
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public <T> T put(String url, Object bodyObject, Class<T> type) {
        Response response = null;
        try {
            String body = this.convert(bodyObject);
            response = ((Request)this.buildRequest(url).setBody(this.encrypt(body))).putResource();
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public <T> T post(String url, Object bodyObject, Class<T> type) {
        Response response = null;
        try {
            Request request = this.buildRequest(url);
            String body = bodyObject != null ? this.encrypt(this.convert(bodyObject)) : "";
            request.setBody(body);
            response = request.postResource();
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public <T> T post(String url, Object bodyObject, Class<T> type, HashMap<String, String> header) {
        Response response = null;
        try {
            String body = this.convert(bodyObject);
            Request request = (Request)this.buildRequest(url).setBody(this.encrypt(body));
            if (header != null) {
                for (String key : header.keySet()) {
                    request = (Request)request.addHeader(key, header.get(key));
                }
            }
            response = request.postResource();
            return this.processResponse(response, type);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new HyperwalletException((Exception)e);
        }
    }

    public Boolean usesProxy() {
        return this.proxy != null;
    }

    public void setProxy(String url, Integer port) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url, (int)port));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    private <T> T processResponse(Response response, Class<T> type) throws ParseException, JOSEException, IOException {
        this.checkErrorResponse(response);
        this.checkResponseHeader(response);
        if (response.getResponseCode() == 204) {
            return this.convert("{}", type);
        }
        return this.convert(this.decryptResponse(response.getBody()), type);
    }

    private <T> T processResponse(Response response, TypeReference<T> type) throws ParseException, JOSEException, IOException {
        this.checkErrorResponse(response);
        this.checkResponseHeader(response);
        if (response.getResponseCode() == 204) {
            return this.convert("{}", type);
        }
        return this.convert(this.decryptResponse(response.getBody()), type);
    }

    protected void checkErrorResponse(Response response) {
        HyperwalletErrorList errorList = null;
        if (response.getResponseCode() >= 400) {
            try {
                errorList = this.convert(this.decryptErrorResponse(response), HyperwalletErrorList.class);
            }
            catch (Exception e) {
                throw new HyperwalletException(response, response.getResponseCode(), response.getResponseMessage(), e);
            }
            if (errorList != null && !errorList.getErrors().isEmpty()) {
                throw new HyperwalletException(response, errorList);
            }
            throw new HyperwalletException(response, response.getResponseCode(), response.getResponseMessage());
        }
    }

    private void checkResponseHeader(Response response) {
        boolean invalidContentType;
        String contentTypeHeader = response.getHeader(CONTENT_TYPE);
        String expectedContentType = this.getContentType();
        boolean bl = invalidContentType = response.getResponseCode() != 204 && contentTypeHeader != null && !contentTypeHeader.contains(expectedContentType);
        if (invalidContentType) {
            throw new HyperwalletException("Invalid Content-Type specified in Response Header");
        }
    }

    private String getAuthorizationHeader() {
        String pair = this.username + ":" + this.password;
        String base64 = DatatypeConverter.printBase64Binary((byte[])pair.getBytes());
        return "Basic " + base64;
    }

    private Request populateCommonHTTPHeader(Request request) {
        return (Request)((Request)((Request)((Request)((Request)request.addHeader("Authorization", this.getAuthorizationHeader())).addHeader("User-Agent", "Hyperwallet Java SDK v" + this.version)).addHeader("x-sdk-version", this.version)).addHeader("x-sdk-type", SDK_TYPE)).addHeader("x-sdk-contextId", this.contextId);
    }

    private Request buildGetRequest(String url) {
        Request request = new Request(url, this.connectionTimeout, this.readTimeout, this.proxy, this.proxyUsername, this.proxyPassword);
        return (Request)this.populateCommonHTTPHeader(request).addHeader(ACCEPT, this.getContentType());
    }

    private Request buildRequest(String url) {
        String contentType = this.getContentType();
        return (Request)((Request)this.buildGetRequest(url).addHeader(ACCEPT, contentType)).addHeader(CONTENT_TYPE, contentType);
    }

    private MultipartRequest buildMultipartRequest(String url) {
        String contentType = this.buildMultipartContentType();
        MultipartRequest request = new MultipartRequest(url, this.connectionTimeout, this.readTimeout, this.proxy, this.proxyUsername, this.proxyPassword);
        return (MultipartRequest)((Request)this.populateCommonHTTPHeader(request).addHeader(ACCEPT, APPLICATION_JSON)).addHeader(CONTENT_TYPE, contentType);
    }

    private String getContentType() {
        return this.isEncrypted ? APPLICATION_JOSE_JSON : APPLICATION_JSON;
    }

    private String buildMultipartContentType() {
        return "multipart/form-data; boundary=--0011010110123111";
    }

    private <T> T convert(String responseBody, Class<T> type) {
        if (responseBody == null) {
            return null;
        }
        return HyperwalletJsonUtil.fromJson(responseBody, type);
    }

    private <T> T convert(String responseBody, TypeReference<T> type) {
        return HyperwalletJsonUtil.fromJson(responseBody, type);
    }

    private String convert(Object object) {
        return HyperwalletJsonUtil.toJson(object);
    }

    private String encrypt(String body) throws JOSEException, IOException, ParseException {
        return this.isEncrypted ? this.hyperwalletEncryption.encrypt(body) : body;
    }

    private String decryptResponse(String responseBody) throws ParseException, IOException, JOSEException {
        if (responseBody == null || responseBody.length() == 0) {
            return null;
        }
        return this.isEncrypted ? this.hyperwalletEncryption.decrypt(responseBody) : responseBody;
    }

    private String decryptErrorResponse(Response response) throws ParseException, IOException, JOSEException {
        String responseBody = response.getBody();
        if (responseBody == null || responseBody.length() == 0) {
            return null;
        }
        return this.isEncrypted && this.isJoseContentType(response) != false ? this.hyperwalletEncryption.decrypt(responseBody) : responseBody;
    }

    private Boolean isJoseContentType(Response response) {
        String contentTypeHeader = response.getHeader(CONTENT_TYPE);
        return contentTypeHeader != null && contentTypeHeader.contains(APPLICATION_JOSE_JSON);
    }
}

