/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.hyperwallet.clientsdk.HyperwalletException;
import com.hyperwallet.clientsdk.model.HyperwalletBaseMonitor;
import com.hyperwallet.clientsdk.util.HyperwalletJsonConfiguration;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class HyperwalletJsonUtil {
    private static ObjectMapper objectMapper = new HyperwalletJsonConfiguration().getContext(Void.class);
    private static ObjectMapper parser = new HyperwalletJsonConfiguration().getParser();

    public HyperwalletJsonUtil() {
        throw new UnsupportedOperationException("This is a util class!");
    }

    public static <T> T fromJson(String content, Class<T> valueType) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return (T)parser.readValue(content, valueType);
        }
        catch (IOException e) {
            throw new HyperwalletException(e);
        }
    }

    public static <T> T fromJson(String content, TypeReference<T> valueType) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        try {
            return (T)parser.readValue(content, valueType);
        }
        catch (IOException e) {
            throw new HyperwalletException(e);
        }
    }

    public static String toJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            HyperwalletBaseMonitor base = (HyperwalletBaseMonitor)object;
            SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("inclusion-filter", SimpleBeanPropertyFilter.filterOutAllExcept(base.getInclusions()));
            ObjectWriter writer = objectMapper.writer((FilterProvider)filters);
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

