/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import com.hyperwallet.clientsdk.model.HyperwalletVerificationDocument;
import com.hyperwallet.clientsdk.util.Multipart;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class HyperwalletMultipartUtils {
    public static Multipart convert(List<HyperwalletVerificationDocument> uploadList) throws IOException {
        Multipart multipartList = new Multipart();
        ArrayList<JSONObject> documents = new ArrayList<JSONObject>();
        for (HyperwalletVerificationDocument uploadData : uploadList) {
            JSONObject document = new JSONObject();
            HyperwalletMultipartUtils.addDocumentValue(document, "type", uploadData.getType());
            HyperwalletMultipartUtils.addDocumentValue(document, "country", uploadData.getCountry());
            HyperwalletMultipartUtils.addDocumentValue(document, "category", uploadData.getCategory());
            HyperwalletMultipartUtils.addDocumentValue(document, "status", uploadData.getStatus());
            documents.add(document);
            for (Map.Entry<String, String> entry : uploadData.getUploadFiles().entrySet()) {
                Path path = Paths.get(entry.getValue(), new String[0]);
                String fileName = path.getFileName().toString();
                String extension = "";
                int i = fileName.lastIndexOf(46);
                if (i >= 0) {
                    extension = fileName.substring(i + 1);
                }
                HashMap<String, String> entity = new HashMap<String, String>();
                entity.put(entry.getKey(), entry.getValue());
                Multipart.MultipartData multipart1 = new Multipart.MultipartData("Content-Type: image/" + extension + "\r\n", "Content-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + fileName + "\" " + "\r\n", entity);
                multipartList.add(multipart1);
            }
        }
        JSONObject data = new JSONObject();
        data.put((Object)"documents", documents);
        HashMap<String, String> multiPartUploadData = new HashMap<String, String>();
        multiPartUploadData.put("data", data.toString());
        Multipart.MultipartData multipart = new Multipart.MultipartData("Content-Type: application/json\r\n", "Content-Disposition: form-data; name=\"data\"\r\n", multiPartUploadData);
        multipartList.add(multipart);
        return multipartList;
    }

    private static void addDocumentValue(JSONObject document, String field, String value) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            document.put((Object)field, (Object)value);
        }
    }
}

