/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Message<T extends Message<T>> {
    Map<String, List<String>> headers = new HashMap<String, List<String>>();
    String body;

    public String getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String label) {
        if (label == null) {
            return null;
        }
        for (String key : this.headers.keySet()) {
            if (!label.equalsIgnoreCase(key)) continue;
            return this.headers.get(key);
        }
        return null;
    }

    public String getHeader(String label) {
        List<String> list = this.getHeaders(label);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public T setBody(String body) {
        this.body = body;
        return (T)this;
    }

    public T addHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
        return (T)this;
    }

    public T removeHeader(String name) {
        this.headers.remove(name);
        return (T)this;
    }

    public T setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return (T)this;
    }

    String encode(String in) {
        try {
            return URLEncoder.encode(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return in;
        }
    }
}

