/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import cc.protea.util.http.Response;
import com.hyperwallet.clientsdk.util.Multipart;
import com.hyperwallet.clientsdk.util.Request;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;

public class MultipartRequest
extends Request {
    public static final String BOUNDARY = "--0011010110123111";
    public static final String CRLF = "\r\n";
    private static final String SEPARATOR = "--";

    public MultipartRequest(String url, int connectionTimeout, int readTimeout, Proxy proxy, String proxyUsername, String proxyPassword) {
        super(url, connectionTimeout, readTimeout, proxy, proxyUsername, proxyPassword);
    }

    public Response putMultipartResource(Multipart multipart) throws IOException {
        return this.writeMuiltipartResource("PUT", multipart);
    }

    private Response writeMuiltipartResource(String method, Multipart multipartList) throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(method);
        DataOutputStream dataOutputStream = new DataOutputStream(this.connection.getOutputStream());
        this.writeMultipartBody(dataOutputStream, multipartList.getMultipartList());
        dataOutputStream.flush();
        dataOutputStream.close();
        Response response = this.readResponse();
        this.connection.disconnect();
        return response;
    }

    private void writeMultipartBody(DataOutputStream dataOutputStream, List<Multipart.MultipartData> multipartList) throws IOException {
        for (Multipart.MultipartData multipartData : multipartList) {
            for (Map.Entry<String, String> entry : multipartData.getEntity().entrySet()) {
                dataOutputStream.writeBytes("----0011010110123111\r\n");
                dataOutputStream.writeBytes(multipartData.getContentDisposition());
                dataOutputStream.writeBytes(multipartData.getContentType());
                dataOutputStream.writeBytes(CRLF);
                if (multipartData.getContentType().contains("image")) {
                    byte[] bytes = Files.readAllBytes(new File(entry.getValue().toString()).toPath());
                    dataOutputStream.write(bytes);
                } else {
                    dataOutputStream.writeBytes(entry.getValue());
                }
                dataOutputStream.writeBytes(CRLF);
                dataOutputStream.flush();
            }
        }
        dataOutputStream.writeBytes(CRLF);
        dataOutputStream.writeBytes("----0011010110123111--\r\n");
    }
}

