/*
 * Decompiled with CFR 0.152.
 */
package com.hyperwallet.clientsdk.util;

import cc.protea.util.http.BinaryResponse;
import cc.protea.util.http.Response;
import com.hyperwallet.clientsdk.util.Message;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Request
extends Message<Request> {
    protected final HttpURLConnection connection;
    private final Map<String, String> query = new HashMap<String, String>();
    private OutputStreamWriter writer;
    private URL url;

    public Request(String url, int connectionTimeout, int readTimeout, Proxy proxy, String proxyUsername, String proxyPassword) {
        try {
            this.url = new URL(url);
            if (proxyUsername != null && proxyPassword != null) {
                DefaultPasswordAuthenticator authenticator = new DefaultPasswordAuthenticator(proxyUsername, proxyPassword);
                Authenticator.setDefault(authenticator);
            }
            HttpURLConnection conn = null;
            conn = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
            this.connection = conn;
            this.connection.setConnectTimeout(connectionTimeout);
            this.connection.setReadTimeout(readTimeout);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Request addQueryParameter(String name, String value) {
        this.query.put(name, value);
        return this;
    }

    public Request removeQueryParameter(String name) {
        this.query.remove(name);
        return this;
    }

    public Response getResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("GET");
        return this.readResponse();
    }

    public BinaryResponse getBinaryResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("GET");
        return this.readBinaryResponse();
    }

    public Response putResource() throws IOException {
        return this.writeResource("PUT", this.body);
    }

    public Response headResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("HEAD");
        return this.readResponse();
    }

    public Response optionsResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("OPTIONS");
        return this.readResponse();
    }

    public Response traceResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("TRACE");
        return this.readResponse();
    }

    public Response postResource() throws IOException {
        return this.writeResource("POST", this.body);
    }

    public Response deleteResource() throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("DELETE");
        return this.readResponse();
    }

    private Response writeResource(String method, String body) throws IOException {
        this.buildQueryString();
        this.buildHeaders();
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(method);
        this.writer = new OutputStreamWriter(this.connection.getOutputStream());
        this.writer.write(body);
        this.writer.close();
        return this.readResponse();
    }

    protected Response readResponse() throws IOException {
        Response response = new Response();
        response.setResponseCode(this.connection.getResponseCode());
        response.setResponseMessage(this.connection.getResponseMessage());
        response.setHeaders(this.connection.getHeaderFields());
        try {
            response.setBody(this.getStringFromStream(this.connection.getInputStream()));
        }
        catch (IOException e) {
            response.setBody(this.getStringFromStream(this.connection.getErrorStream()));
        }
        return response;
    }

    private BinaryResponse readBinaryResponse() throws IOException {
        BinaryResponse response = new BinaryResponse();
        response.setResponseCode(this.connection.getResponseCode());
        response.setResponseMessage(this.connection.getResponseMessage());
        response.setHeaders(this.connection.getHeaderFields());
        try {
            response.setBinaryBody(this.getBinaryFromStream(this.connection.getInputStream()));
        }
        catch (IOException e) {
            response.setBinaryBody(this.getBinaryFromStream(this.connection.getErrorStream()));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBinaryFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[65535];
            int len = is.read(buffer);
            while (len != -1) {
                os.write(buffer, 0, len);
                len = is.read(buffer);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void buildQueryString() throws MalformedURLException {
        StringBuilder builder = new StringBuilder();
        if (!this.query.isEmpty()) {
            for (Map.Entry<String, String> param : this.query.entrySet()) {
                builder.append(param.getKey());
                builder.append("=");
                builder.append(param.getValue());
                builder.append("&");
            }
            builder.deleteCharAt(builder.lastIndexOf("&"));
        }
        if (builder.length() > 0) {
            builder.insert(0, "?");
        }
        this.url = new URL(this.url.toString() + builder.toString());
    }

    protected void buildHeaders() {
        if (!this.headers.isEmpty()) {
            for (Map.Entry entry : this.headers.entrySet()) {
                List values = (List)entry.getValue();
                for (String value : values) {
                    this.connection.addRequestProperty((String)entry.getKey(), value);
                }
            }
        }
    }

    public Request setBodyUrlEncoded(Map<String, String> map) {
        if (map == null) {
            this.body = null;
            return this;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(first ? "" : "&").append(this.encode(entry.getKey())).append("=").append(this.encode(entry.getValue()));
            first = false;
        }
        this.setBody(sb.toString());
        this.addHeader("Content-type", "application/x-www-form-urlencoded");
        this.addHeader("Content-length", "" + this.body.length());
        return this;
    }

    public static class DefaultPasswordAuthenticator
    extends Authenticator {
        private String userName;
        private String password;

        public DefaultPasswordAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password.toCharArray());
        }
    }
}

