/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder;

import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.section.EncodableSection;
import com.iab.gpp.encoder.section.HeaderV1;
import com.iab.gpp.encoder.section.Sections;
import com.iab.gpp.encoder.section.TcfCaV1;
import com.iab.gpp.encoder.section.TcfEuV2;
import com.iab.gpp.encoder.section.UspCaV1;
import com.iab.gpp.encoder.section.UspCoV1;
import com.iab.gpp.encoder.section.UspCtV1;
import com.iab.gpp.encoder.section.UspNatV1;
import com.iab.gpp.encoder.section.UspUtV1;
import com.iab.gpp.encoder.section.UspV1;
import com.iab.gpp.encoder.section.UspVaV1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GppModel {
    private Map<String, EncodableSection> sections = new HashMap<String, EncodableSection>();

    public GppModel() {
    }

    public GppModel(String encodedString) throws DecodingException {
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    public void setFieldValue(int sectionId, String fieldName, Object value) throws InvalidFieldException {
        this.setFieldValue(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName, value);
    }

    public void setFieldValue(String sectionName, String fieldName, Object value) throws InvalidFieldException {
        EncodableSection section = null;
        if (!this.sections.containsKey(sectionName)) {
            if (sectionName.equals(TcfCaV1.NAME)) {
                section = new TcfCaV1();
                this.sections.put(TcfCaV1.NAME, section);
            } else if (sectionName.equals(TcfEuV2.NAME)) {
                section = new TcfEuV2();
                this.sections.put(TcfEuV2.NAME, section);
            } else if (sectionName.equals(UspV1.NAME)) {
                section = new UspV1();
                this.sections.put(UspV1.NAME, section);
            } else if (sectionName.equals(UspNatV1.NAME)) {
                section = new UspNatV1();
                this.sections.put(UspNatV1.NAME, section);
            } else if (sectionName.equals(UspCaV1.NAME)) {
                section = new UspCaV1();
                this.sections.put(UspCaV1.NAME, section);
            } else if (sectionName.equals(UspVaV1.NAME)) {
                section = new UspVaV1();
                this.sections.put(UspVaV1.NAME, section);
            } else if (sectionName.equals(UspCoV1.NAME)) {
                section = new UspCoV1();
                this.sections.put(UspCoV1.NAME, section);
            } else if (sectionName.equals(UspUtV1.NAME)) {
                section = new UspUtV1();
                this.sections.put(UspUtV1.NAME, section);
            } else if (sectionName.equals(UspCtV1.NAME)) {
                section = new UspCtV1();
                this.sections.put(UspCtV1.NAME, section);
            }
        } else {
            section = this.sections.get(sectionName);
        }
        if (section == null) {
            throw new InvalidFieldException(sectionName + "." + fieldName + " not found");
        }
        section.setFieldValue(fieldName, value);
    }

    public Object getFieldValue(int sectionId, String fieldName) {
        return this.getFieldValue(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName);
    }

    public Object getFieldValue(String sectionName, String fieldName) {
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).getFieldValue(fieldName);
        }
        return null;
    }

    public boolean hasField(int sectionId, String fieldName) {
        return this.hasField(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName);
    }

    public boolean hasField(String sectionName, String fieldName) {
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).hasField(fieldName);
        }
        return false;
    }

    public boolean hasSection(int sectionId) {
        return this.hasSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public boolean hasSection(String sectionName) {
        return this.sections.containsKey(sectionName);
    }

    public HeaderV1 getHeader() {
        HeaderV1 header = new HeaderV1();
        try {
            header.setFieldValue("SectionIds", this.getSectionIds());
        }
        catch (InvalidFieldException invalidFieldException) {
            // empty catch block
        }
        return header;
    }

    public EncodableSection getSection(int sectionId) {
        return this.getSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public EncodableSection getSection(String sectionName) {
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName);
        }
        return null;
    }

    public void deleteSection(int sectionId) {
        this.deleteSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public void deleteSection(String sectionName) {
        if (this.sections.containsKey(sectionName)) {
            this.sections.remove(sectionName);
        }
    }

    public void clear() {
        this.sections.clear();
    }

    public TcfCaV1 getTcfCaV1Section() {
        return (TcfCaV1)this.getSection(TcfCaV1.NAME);
    }

    public TcfEuV2 getTcfEuV2Section() {
        return (TcfEuV2)this.getSection(TcfEuV2.NAME);
    }

    public UspV1 getUspV1Section() {
        return (UspV1)this.getSection(UspV1.NAME);
    }

    public UspNatV1 getUspNatV1Section() {
        return (UspNatV1)this.getSection(UspNatV1.NAME);
    }

    public UspCaV1 getUspCaV1Section() {
        return (UspCaV1)this.getSection(UspCaV1.NAME);
    }

    public UspVaV1 getUspVaV1Section() {
        return (UspVaV1)this.getSection(UspVaV1.NAME);
    }

    public UspCoV1 getUspCoV1Section() {
        return (UspCoV1)this.getSection(UspCoV1.NAME);
    }

    public UspUtV1 getUspUtV1Section() {
        return (UspUtV1)this.getSection(UspUtV1.NAME);
    }

    public UspCtV1 getUspCtV1Section() {
        return (UspCtV1)this.getSection(UspCtV1.NAME);
    }

    public List<Integer> getSectionIds() {
        ArrayList<Integer> sectionIds = new ArrayList<Integer>();
        for (int i = 0; i < Sections.SECTION_ORDER.size(); ++i) {
            String sectionName = Sections.SECTION_ORDER.get(i);
            if (!this.sections.containsKey(sectionName)) continue;
            EncodableSection section = this.sections.get(sectionName);
            sectionIds.add(section.getId());
        }
        return sectionIds;
    }

    public String encode() throws EncodingException {
        ArrayList<String> encodedSections = new ArrayList<String>();
        ArrayList<Integer> sectionIds = new ArrayList<Integer>();
        for (int i = 0; i < Sections.SECTION_ORDER.size(); ++i) {
            String sectionName = Sections.SECTION_ORDER.get(i);
            if (!this.sections.containsKey(sectionName)) continue;
            EncodableSection section = this.sections.get(sectionName);
            encodedSections.add(section.encode());
            sectionIds.add(section.getId());
        }
        HeaderV1 header = new HeaderV1();
        try {
            header.setFieldValue("SectionIds", this.getSectionIds());
        }
        catch (InvalidFieldException e) {
            throw new EncodingException(e);
        }
        encodedSections.add(0, header.encode());
        String encodedString = encodedSections.stream().collect(Collectors.joining("~"));
        return encodedString;
    }

    public void decode(String str) throws DecodingException {
        this.sections.clear();
        String[] encodedSections = str.split("~");
        HeaderV1 header = new HeaderV1(encodedSections[0]);
        this.sections.put(HeaderV1.NAME, header);
        List sectionIds = (List)header.getFieldValue("SectionIds");
        for (int i = 0; i < sectionIds.size(); ++i) {
            EncodableSection section;
            if (((Integer)sectionIds.get(i)).equals(TcfEuV2.ID)) {
                section = new TcfEuV2(encodedSections[i + 1]);
                this.sections.put(TcfEuV2.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(TcfCaV1.ID)) {
                section = new TcfCaV1(encodedSections[i + 1]);
                this.sections.put(TcfCaV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspV1.ID)) {
                section = new UspV1(encodedSections[i + 1]);
                this.sections.put(UspV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspCaV1.ID)) {
                section = new UspCaV1(encodedSections[i + 1]);
                this.sections.put(UspCaV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspNatV1.ID)) {
                section = new UspNatV1(encodedSections[i + 1]);
                this.sections.put(UspNatV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspVaV1.ID)) {
                section = new UspVaV1(encodedSections[i + 1]);
                this.sections.put(UspVaV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspCoV1.ID)) {
                section = new UspCoV1(encodedSections[i + 1]);
                this.sections.put(UspCoV1.NAME, section);
                continue;
            }
            if (((Integer)sectionIds.get(i)).equals(UspUtV1.ID)) {
                section = new UspUtV1(encodedSections[i + 1]);
                this.sections.put(UspUtV1.NAME, section);
                continue;
            }
            if (!((Integer)sectionIds.get(i)).equals(UspCtV1.ID)) continue;
            section = new UspCtV1(encodedSections[i + 1]);
            this.sections.put(UspCtV1.NAME, section);
        }
    }

    public String encodeSection(int sectionId) throws EncodingException {
        return this.encodeSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public String encodeSection(String sectionName) throws EncodingException {
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).encode();
        }
        return null;
    }

    public void decodeSection(int sectionId, String encodedString) throws DecodingException {
        this.decodeSection(Sections.SECTION_ID_NAME_MAP.get(sectionId), encodedString);
    }

    public void decodeSection(String sectionName, String encodedString) throws DecodingException {
        EncodableSection section = null;
        if (!this.sections.containsKey(sectionName)) {
            if (sectionName.equals(TcfEuV2.NAME)) {
                section = new TcfEuV2();
                this.sections.put(TcfEuV2.NAME, section);
            } else if (sectionName.equals(TcfCaV1.NAME)) {
                section = new TcfCaV1();
                this.sections.put(TcfCaV1.NAME, section);
            } else if (sectionName.equals(UspV1.NAME)) {
                section = new UspV1();
                this.sections.put(UspV1.NAME, section);
            } else if (sectionName.equals(UspV1.NAME)) {
                section = new UspV1();
                this.sections.put(UspV1.NAME, section);
            } else if (sectionName.equals(UspNatV1.NAME)) {
                section = new UspNatV1();
                this.sections.put(UspNatV1.NAME, section);
            } else if (sectionName.equals(UspCaV1.NAME)) {
                section = new UspCaV1();
                this.sections.put(UspCaV1.NAME, section);
            } else if (sectionName.equals(UspVaV1.NAME)) {
                section = new UspVaV1();
                this.sections.put(UspVaV1.NAME, section);
            } else if (sectionName.equals(UspCoV1.NAME)) {
                section = new UspCoV1();
                this.sections.put(UspCoV1.NAME, section);
            } else if (sectionName.equals(UspUtV1.NAME)) {
                section = new UspUtV1();
                this.sections.put(UspUtV1.NAME, section);
            } else if (sectionName.equals(UspCtV1.NAME)) {
                section = new UspCtV1();
                this.sections.put(UspCtV1.NAME, section);
            }
        } else {
            section = this.sections.get(sectionName);
        }
        if (section != null) {
            section.decode(encodedString);
        }
    }
}

