/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerListEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncodableFixedIntegerList
extends AbstractEncodableBitStringDataType<List<Integer>> {
    private int elementBitStringLength;
    private int numElements;

    protected EncodableFixedIntegerList(int elementBitStringLength, int numElements) {
        this.elementBitStringLength = elementBitStringLength;
        this.numElements = numElements;
    }

    public EncodableFixedIntegerList(int elementBitStringLength, List<Integer> value) {
        this.elementBitStringLength = elementBitStringLength;
        this.numElements = value.size();
        this.setValue(value);
    }

    @Override
    public String encode() throws EncodingException {
        return FixedIntegerListEncoder.encode((List)this.value, this.elementBitStringLength, this.numElements);
    }

    @Override
    public void decode(String bitString) throws DecodingException {
        this.value = FixedIntegerListEncoder.decode(bitString, this.elementBitStringLength, this.numElements);
    }

    @Override
    public String substring(String bitString, int fromIndex) {
        return bitString.substring(fromIndex, fromIndex + this.elementBitStringLength * this.numElements);
    }

    @Override
    public void setValue(Object value) {
        List<Integer> v = new ArrayList<Integer>((List)value);
        for (int i = v.size(); i < this.numElements; ++i) {
            v.add(0);
        }
        if (v.size() > this.numElements) {
            v = v.subList(0, this.numElements);
        }
        super.setValue(v);
    }

    @Override
    public List<Integer> getValue() {
        return new ArrayList<Integer>((Collection)super.getValue());
    }
}

