/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.encoder.FixedBitfieldEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncodableFixedNullableBitfield
extends AbstractEncodableBitStringDataType<List<Boolean>> {
    private int numElements;

    protected EncodableFixedNullableBitfield(int numElements) {
        this.numElements = numElements;
    }

    public EncodableFixedNullableBitfield(List<Boolean> value) {
        this.numElements = value.size();
        this.setValue(value);
    }

    @Override
    public String encode() throws EncodingException {
        return FixedBitfieldEncoder.encode((List)this.value, this.numElements);
    }

    @Override
    public void decode(String bitString) throws DecodingException {
        this.value = FixedBitfieldEncoder.decode(bitString);
    }

    @Override
    public String substring(String bitString, int fromIndex) {
        return bitString.substring(fromIndex, fromIndex + this.numElements);
    }

    @Override
    public void setValue(Object value) {
        List<Boolean> v = new ArrayList<Boolean>((List)value);
        for (int i = v.size(); i < this.numElements; ++i) {
            v.add(false);
        }
        if (v.size() > this.numElements) {
            v = v.subList(0, this.numElements);
        }
        super.setValue(v);
    }

    @Override
    public List<Boolean> getValue() {
        return new ArrayList<Boolean>((Collection)super.getValue());
    }
}

