/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.encoder.FixedBitfieldEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntSupplier;

public class EncodableFlexibleBitfield
extends AbstractEncodableBitStringDataType<List<Boolean>> {
    private IntSupplier getLengthSupplier;

    protected EncodableFlexibleBitfield(IntSupplier getLengthSupplier) {
        this.getLengthSupplier = getLengthSupplier;
    }

    public EncodableFlexibleBitfield(IntSupplier getLengthSupplier, List<Boolean> value) {
        this.getLengthSupplier = getLengthSupplier;
        this.setValue(value);
    }

    @Override
    public String encode() throws EncodingException {
        return FixedBitfieldEncoder.encode((List)this.value, this.getLengthSupplier.getAsInt());
    }

    @Override
    public void decode(String bitString) throws DecodingException {
        this.value = FixedBitfieldEncoder.decode(bitString);
    }

    @Override
    public String substring(String bitString, int fromIndex) {
        return bitString.substring(fromIndex, fromIndex + this.getLengthSupplier.getAsInt());
    }

    @Override
    public void setValue(Object value) {
        int numElements = this.getLengthSupplier.getAsInt();
        List<Boolean> v = new ArrayList<Boolean>((List)value);
        for (int i = v.size(); i < numElements; ++i) {
            v.add(false);
        }
        if (v.size() > numElements) {
            v = v.subList(0, numElements);
        }
        super.setValue(v);
    }

    @Override
    public List<Boolean> getValue() {
        return new ArrayList<Boolean>((Collection)super.getValue());
    }
}

