/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableFibonacciIntegerRange;
import com.iab.gpp.encoder.datatype.encoder.FibonacciIntegerRangeEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedBitfieldEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class EncodableOptimizedFibonacciRange
extends AbstractEncodableBitStringDataType<List<Integer>> {
    protected EncodableOptimizedFibonacciRange() {
    }

    public EncodableOptimizedFibonacciRange(List<Integer> value) {
        this.setValue(value);
    }

    @Override
    public String encode() throws EncodingException {
        int bitFieldLength;
        int max = ((List)this.value).size() > 0 ? (Integer)((List)this.value).get(((List)this.value).size() - 1) : 0;
        String rangeBitString = FibonacciIntegerRangeEncoder.encode((List)this.value);
        int rangeLength = rangeBitString.length();
        if (rangeLength <= (bitFieldLength = max)) {
            return FixedIntegerEncoder.encode(max, 16) + "1" + rangeBitString;
        }
        ArrayList<Boolean> bits = new ArrayList<Boolean>();
        int index = 0;
        for (int i = 0; i < max; ++i) {
            if (i == (Integer)((List)this.value).get(index) - 1) {
                bits.add(true);
                ++index;
                continue;
            }
            bits.add(false);
        }
        return FixedIntegerEncoder.encode(max, 16) + "0" + FixedBitfieldEncoder.encode(bits, bitFieldLength);
    }

    @Override
    public void decode(String bitString) throws DecodingException {
        if (bitString.charAt(16) == '1') {
            this.value = FibonacciIntegerRangeEncoder.decode(bitString.substring(17));
        } else {
            ArrayList<Integer> value = new ArrayList<Integer>();
            List<Boolean> bits = FixedBitfieldEncoder.decode(bitString.substring(17));
            for (int i = 0; i < bits.size(); ++i) {
                if (!bits.get(i).booleanValue()) continue;
                value.add(i + 1);
            }
            this.value = value;
        }
    }

    @Override
    public String substring(String bitString, int fromIndex) throws DecodingException {
        int max = FixedIntegerEncoder.decode(bitString.substring(fromIndex, fromIndex + 16));
        if (bitString.charAt(fromIndex + 16) == '1') {
            return bitString.substring(fromIndex, fromIndex + 17) + new EncodableFibonacciIntegerRange().substring(bitString, fromIndex + 17);
        }
        return bitString.substring(fromIndex, fromIndex + 17 + max);
    }

    @Override
    public void setValue(Object value) {
        super.setValue(new ArrayList(new TreeSet((List)value)));
    }

    @Override
    public List<Integer> getValue() {
        return new ArrayList<Integer>((Collection)super.getValue());
    }
}

