/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.FixedLongEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;

public class DatetimeEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(ZonedDateTime value) {
        if (value != null) {
            return FixedLongEncoder.encode(value.toInstant().toEpochMilli() / 100L, 36);
        }
        return FixedLongEncoder.encode(0L, 36);
    }

    public static ZonedDateTime decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() != 36) {
            throw new DecodingException("Undecodable Datetime '" + bitString + "'");
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(FixedLongEncoder.decode(bitString) * 100L), ZoneId.of("UTC"));
    }
}

