/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.BooleanEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class FixedBitfieldEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(List<Boolean> value, int bitStringLength) throws EncodingException {
        String bitString = "";
        for (int i = 0; i < value.size(); ++i) {
            bitString = bitString + BooleanEncoder.encode(value.get(i));
        }
        while (bitString.length() < bitStringLength) {
            bitString = bitString + "0";
        }
        return bitString;
    }

    public static List<Boolean> decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches()) {
            throw new DecodingException("Undecodable FixedBitfield '" + bitString + "'");
        }
        ArrayList<Boolean> value = new ArrayList<Boolean>();
        for (int i = 0; i < bitString.length(); ++i) {
            value.add(BooleanEncoder.decode(bitString.substring(i, i + 1)));
        }
        return value;
    }
}

