/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.error.DecodingException;
import java.util.regex.Pattern;

public class FixedIntegerEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(int value, int bitStringLength) {
        String bitString = "";
        while (value > 0) {
            bitString = (value & 1) == 1 ? "1" + bitString : "0" + bitString;
            value >>= 1;
        }
        while (bitString.length() < bitStringLength) {
            bitString = "0" + bitString;
        }
        return bitString;
    }

    public static int decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches()) {
            throw new DecodingException("Undecodable FixedInteger '" + bitString + "'");
        }
        int value = 0;
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(bitString.length() - (i + 1)) != '1') continue;
            value += 1 << i;
        }
        return value;
    }
}

