/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.BooleanEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FixedIntegerRangeEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(List<Integer> value) {
        Collections.sort(value);
        ArrayList<List<Integer>> groups = new ArrayList<List<Integer>>();
        int groupStartIndex = 0;
        while (groupStartIndex < value.size()) {
            int groupEndIndex;
            for (groupEndIndex = groupStartIndex; groupEndIndex < value.size() - 1 && value.get(groupEndIndex) + 1 == value.get(groupEndIndex + 1); ++groupEndIndex) {
            }
            groups.add(value.subList(groupStartIndex, groupEndIndex + 1));
            groupStartIndex = groupEndIndex + 1;
        }
        String bitString = FixedIntegerEncoder.encode(groups.size(), 12);
        for (int i = 0; i < groups.size(); ++i) {
            bitString = ((List)groups.get(i)).size() == 1 ? bitString + "0" + FixedIntegerEncoder.encode((Integer)((List)groups.get(i)).get(0), 16) : bitString + "1" + FixedIntegerEncoder.encode((Integer)((List)groups.get(i)).get(0), 16) + FixedIntegerEncoder.encode((Integer)((List)groups.get(i)).get(((List)groups.get(i)).size() - 1), 16);
        }
        return bitString;
    }

    public static List<Integer> decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() < 12) {
            throw new DecodingException("Undecodable FixedIntegerRange '" + bitString + "'");
        }
        ArrayList<Integer> value = new ArrayList<Integer>();
        int count = FixedIntegerEncoder.decode(bitString.substring(0, 12));
        int startIndex = 12;
        for (int i = 0; i < count; ++i) {
            boolean group = BooleanEncoder.decode(bitString.substring(startIndex, startIndex + 1));
            ++startIndex;
            if (group) {
                int start = FixedIntegerEncoder.decode(bitString.substring(startIndex, startIndex + 16));
                int end = FixedIntegerEncoder.decode(bitString.substring(startIndex += 16, startIndex + 16));
                startIndex += 16;
                for (int j = start; j <= end; ++j) {
                    value.add(j);
                }
                continue;
            }
            int val = FixedIntegerEncoder.decode(bitString.substring(startIndex, startIndex + 16));
            value.add(val);
            startIndex += 16;
        }
        return value;
    }
}

