/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.section.EncodableSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractEncodableSegmentedBitStringSection
implements EncodableSection {
    protected Map<String, AbstractEncodableBitStringDataType<?>> fields;
    protected String[][] segments;

    @Override
    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    @Override
    public Object getFieldValue(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName).getValue();
        }
        return null;
    }

    @Override
    public void setFieldValue(String fieldName, Object value) throws InvalidFieldException {
        if (!this.fields.containsKey(fieldName)) {
            throw new InvalidFieldException(fieldName + " not found");
        }
        this.fields.get(fieldName).setValue(value);
    }

    public String[][] getSegments() {
        return this.segments;
    }

    public List<String> encodeSegmentsToBitStrings() throws EncodingException {
        ArrayList<String> segmentBitStrings = new ArrayList<String>();
        for (int i = 0; i < this.segments.length; ++i) {
            String segmentBitString = "";
            for (int j = 0; j < this.segments[i].length; ++j) {
                String fieldName = this.segments[i][j];
                if (this.fields.containsKey(fieldName)) {
                    try {
                        AbstractEncodableBitStringDataType<?> field = this.fields.get(fieldName);
                        segmentBitString = segmentBitString + field.encode();
                        continue;
                    }
                    catch (Exception e) {
                        throw new EncodingException("Unable to encode " + fieldName, e);
                    }
                }
                throw new EncodingException("Field not found: '" + fieldName + "'");
            }
            segmentBitStrings.add(segmentBitString);
        }
        return segmentBitStrings;
    }

    public void decodeSegmentsFromBitStrings(List<String> segmentBitStrings) throws DecodingException {
        for (int i = 0; i < this.segments.length && i < segmentBitStrings.size(); ++i) {
            String segmentBitString = segmentBitStrings.get(i);
            if (segmentBitString == null || segmentBitString.length() <= 0) continue;
            int index = 0;
            for (int j = 0; j < this.segments[i].length; ++j) {
                String fieldName = this.segments[i][j];
                if (this.fields.containsKey(fieldName)) {
                    try {
                        AbstractEncodableBitStringDataType<?> field = this.fields.get(fieldName);
                        String substring = field.substring(segmentBitString, index);
                        field.decode(substring);
                        index += substring.length();
                        continue;
                    }
                    catch (Exception e) {
                        throw new DecodingException("Unable to decode " + fieldName, e);
                    }
                }
                throw new DecodingException("Field not found: '" + fieldName + "'");
            }
        }
    }

    @Override
    public abstract String encode() throws EncodingException;

    @Override
    public abstract void decode(String var1) throws DecodingException;

    @Override
    public abstract int getId();

    @Override
    public abstract String getName();
}

