/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableFibonacciIntegerRange;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.encoder.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.datatype.encoder.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.field.HeaderV1Field;
import com.iab.gpp.encoder.section.AbstractEncodableBitStringSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HeaderV1
extends AbstractEncodableBitStringSection {
    public static int ID = 3;
    public static int VERSION = 1;
    public static String NAME = "header";
    private AbstractBase64UrlEncoder base64UrlEncoder = new CompressedBase64UrlEncoder();

    public HeaderV1() {
        this.initFields();
    }

    public HeaderV1(String encodedString) throws DecodingException {
        this.initFields();
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    private void initFields() {
        this.fields = new HashMap();
        this.fields.put(HeaderV1Field.ID, new EncodableFixedInteger(6, ID));
        this.fields.put(HeaderV1Field.VERSION, new EncodableFixedInteger(6, VERSION));
        this.fields.put(HeaderV1Field.SECTION_IDS, new EncodableFibonacciIntegerRange(new ArrayList<Integer>()));
        this.fieldOrder = new String[]{HeaderV1Field.ID, HeaderV1Field.VERSION, HeaderV1Field.SECTION_IDS};
    }

    @Override
    public String encode() throws EncodingException {
        String bitString = this.encodeToBitString();
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    public void decode(String encodedString) throws DecodingException {
        String bitString = this.base64UrlEncoder.decode(encodedString);
        this.decodeFromBitString(bitString);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Integer getVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(HeaderV1Field.VERSION)).getValue();
    }

    public List<Integer> getSectionsIds() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(HeaderV1Field.SECTION_IDS)).getValue();
    }
}

