/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableBoolean;
import com.iab.gpp.encoder.datatype.EncodableDatetime;
import com.iab.gpp.encoder.datatype.EncodableFixedBitfield;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedString;
import com.iab.gpp.encoder.datatype.EncodableFlexibleBitfield;
import com.iab.gpp.encoder.datatype.EncodableOptimizedFixedRange;
import com.iab.gpp.encoder.datatype.encoder.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.datatype.encoder.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.TcfCaV1Field;
import com.iab.gpp.encoder.section.AbstractEncodableSegmentedBitStringSection;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;

public class TcfCaV1
extends AbstractEncodableSegmentedBitStringSection {
    public static int ID = 5;
    public static int VERSION = 2;
    public static String NAME = "tcfcav1";
    private AbstractBase64UrlEncoder base64UrlEncoder = new CompressedBase64UrlEncoder();

    public TcfCaV1() {
        this.initFields();
    }

    public TcfCaV1(String encodedString) throws DecodingException {
        this.initFields();
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    private void initFields() {
        this.fields = new HashMap();
        ZonedDateTime date = ZonedDateTime.now();
        this.fields.put(TcfCaV1Field.VERSION, new EncodableFixedInteger(6, VERSION));
        this.fields.put(TcfCaV1Field.CREATED, new EncodableDatetime(date));
        this.fields.put(TcfCaV1Field.LAST_UPDATED, new EncodableDatetime(date));
        this.fields.put(TcfCaV1Field.CMP_ID, new EncodableFixedInteger(12, 0));
        this.fields.put(TcfCaV1Field.CMP_VERSION, new EncodableFixedInteger(12, 0));
        this.fields.put(TcfCaV1Field.CONSENT_SCREEN, new EncodableFixedInteger(6, 0));
        this.fields.put(TcfCaV1Field.CONSENT_LANGUAGE, new EncodableFixedString(2, "EN"));
        this.fields.put(TcfCaV1Field.VENDOR_LIST_VERSION, new EncodableFixedInteger(12, 0));
        this.fields.put(TcfCaV1Field.TCF_POLICY_VERSION, new EncodableFixedInteger(6, 2));
        this.fields.put(TcfCaV1Field.USE_NON_STANDARD_STACKS, new EncodableBoolean(false));
        this.fields.put(TcfCaV1Field.SPECIAL_FEATURE_EXPRESS_CONSENT, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false)));
        this.fields.put(TcfCaV1Field.PURPOSES_EXPRESS_CONSENT, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        this.fields.put(TcfCaV1Field.PURPOSES_IMPLIED_CONSENT, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        this.fields.put(TcfCaV1Field.VENDOR_EXPRESS_CONSENT, new EncodableOptimizedFixedRange(new ArrayList<Integer>()));
        this.fields.put(TcfCaV1Field.VENDOR_IMPLIED_CONSENT, new EncodableOptimizedFixedRange(new ArrayList<Integer>()));
        this.fields.put(TcfCaV1Field.PUB_PURPOSES_SEGMENT_TYPE, new EncodableFixedInteger(3, 3));
        this.fields.put(TcfCaV1Field.PUB_PURPOSES_EXPRESS_CONSENT, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        this.fields.put(TcfCaV1Field.PUB_PURPOSES_IMPLIED_CONSENT, new EncodableFixedBitfield(Arrays.asList(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false)));
        final EncodableFixedInteger numCustomPurposes = new EncodableFixedInteger(6, 0);
        this.fields.put(TcfCaV1Field.NUM_CUSTOM_PURPOSES, numCustomPurposes);
        IntSupplier getLengthSupplier = new IntSupplier(){

            @Override
            public int getAsInt() {
                return (Integer)numCustomPurposes.getValue();
            }
        };
        this.fields.put(TcfCaV1Field.CUSTOM_PURPOSES_EXPRESS_CONSENT, new EncodableFlexibleBitfield(getLengthSupplier, new ArrayList<Boolean>()));
        this.fields.put(TcfCaV1Field.CUSTOM_PURPOSES_IMPLIED_CONSENT, new EncodableFlexibleBitfield(getLengthSupplier, new ArrayList<Boolean>()));
        String[] coreSegment = new String[]{TcfCaV1Field.VERSION, TcfCaV1Field.CREATED, TcfCaV1Field.LAST_UPDATED, TcfCaV1Field.CMP_ID, TcfCaV1Field.CMP_VERSION, TcfCaV1Field.CONSENT_SCREEN, TcfCaV1Field.CONSENT_LANGUAGE, TcfCaV1Field.VENDOR_LIST_VERSION, TcfCaV1Field.TCF_POLICY_VERSION, TcfCaV1Field.USE_NON_STANDARD_STACKS, TcfCaV1Field.SPECIAL_FEATURE_EXPRESS_CONSENT, TcfCaV1Field.PURPOSES_EXPRESS_CONSENT, TcfCaV1Field.PURPOSES_IMPLIED_CONSENT, TcfCaV1Field.VENDOR_EXPRESS_CONSENT, TcfCaV1Field.VENDOR_IMPLIED_CONSENT};
        String[] publisherPurposesSegment = new String[]{TcfCaV1Field.PUB_PURPOSES_SEGMENT_TYPE, TcfCaV1Field.PUB_PURPOSES_EXPRESS_CONSENT, TcfCaV1Field.PUB_PURPOSES_IMPLIED_CONSENT, TcfCaV1Field.NUM_CUSTOM_PURPOSES, TcfCaV1Field.CUSTOM_PURPOSES_EXPRESS_CONSENT, TcfCaV1Field.CUSTOM_PURPOSES_IMPLIED_CONSENT};
        this.segments = new String[][]{coreSegment, publisherPurposesSegment};
    }

    @Override
    public String encode() throws EncodingException {
        List<String> segmentBitStrings = this.encodeSegmentsToBitStrings();
        ArrayList<String> encodedSegments = new ArrayList<String>();
        if (segmentBitStrings.size() >= 1) {
            encodedSegments.add(this.base64UrlEncoder.encode(segmentBitStrings.get(0)));
            if (segmentBitStrings.size() >= 2) {
                encodedSegments.add(this.base64UrlEncoder.encode(segmentBitStrings.get(1)));
            }
        }
        return encodedSegments.stream().collect(Collectors.joining("."));
    }

    @Override
    public void decode(String encodedSection) throws DecodingException {
        String[] encodedSegments = encodedSection.split("\\.");
        String[] segmentBitStrings = new String[4];
        block8: for (int i = 0; i < encodedSegments.length; ++i) {
            String segmentBitString = this.base64UrlEncoder.decode(encodedSegments[i]);
            switch (segmentBitString.substring(0, 3)) {
                case "000": {
                    segmentBitStrings[0] = segmentBitString;
                    continue block8;
                }
                case "011": {
                    segmentBitStrings[1] = segmentBitString;
                    continue block8;
                }
                default: {
                    throw new DecodingException("Unable to decode segment '" + encodedSegments[i] + "'");
                }
            }
        }
        this.decodeSegmentsFromBitStrings(Arrays.asList(segmentBitStrings));
    }

    @Override
    public void setFieldValue(String fieldName, Object value) throws InvalidFieldException {
        super.setFieldValue(fieldName, value);
        if (!fieldName.equals(TcfCaV1Field.CREATED) && !fieldName.equals(TcfCaV1Field.LAST_UPDATED)) {
            ZonedDateTime utcDateTime = ZonedDateTime.now(ZoneId.of("UTC"));
            super.setFieldValue(TcfCaV1Field.CREATED, utcDateTime);
            super.setFieldValue(TcfCaV1Field.LAST_UPDATED, utcDateTime);
        }
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Integer getVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.VERSION)).getValue();
    }

    public ZonedDateTime getCreated() {
        return (ZonedDateTime)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CREATED)).getValue();
    }

    public ZonedDateTime getLastUpdated() {
        return (ZonedDateTime)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.LAST_UPDATED)).getValue();
    }

    public Integer getCmpId() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CMP_ID)).getValue();
    }

    public Integer getCmpVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CMP_VERSION)).getValue();
    }

    public Integer getConsentScreen() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CONSENT_SCREEN)).getValue();
    }

    public String getConsentLanguage() {
        return (String)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CONSENT_LANGUAGE)).getValue();
    }

    public Integer getVendorListVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.VENDOR_LIST_VERSION)).getValue();
    }

    public Integer getPolicyVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.TCF_POLICY_VERSION)).getValue();
    }

    public Boolean getUseNonStandardStacks() {
        return (Boolean)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.USE_NON_STANDARD_STACKS)).getValue();
    }

    public List<Boolean> getSpecialFeatureExpressConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.SPECIAL_FEATURE_EXPRESS_CONSENT)).getValue();
    }

    public List<Boolean> getPurposesExpressConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.PURPOSES_EXPRESS_CONSENT)).getValue();
    }

    public List<Boolean> getPurposesImpliedConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.PURPOSES_IMPLIED_CONSENT)).getValue();
    }

    public List<Integer> getVendorExpressConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.VENDOR_EXPRESS_CONSENT)).getValue();
    }

    public List<Integer> getVendorImpliedConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.VENDOR_IMPLIED_CONSENT)).getValue();
    }

    public Integer getPubPurposesSegmentType() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.PUB_PURPOSES_SEGMENT_TYPE)).getValue();
    }

    public List<Boolean> getPubPurposesExpressConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.PUB_PURPOSES_EXPRESS_CONSENT)).getValue();
    }

    public List<Boolean> getPubPurposesImpliedConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.PUB_PURPOSES_IMPLIED_CONSENT)).getValue();
    }

    public Integer getNumCustomPurposes() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.NUM_CUSTOM_PURPOSES)).getValue();
    }

    public List<Integer> getCustomPurposesExpressConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CUSTOM_PURPOSES_EXPRESS_CONSENT)).getValue();
    }

    public List<Integer> getCustomPurposesImpliedConsent() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(TcfCaV1Field.CUSTOM_PURPOSES_IMPLIED_CONSENT)).getValue();
    }
}

