/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableBoolean;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerList;
import com.iab.gpp.encoder.datatype.encoder.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.datatype.encoder.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.field.UspCaV1Field;
import com.iab.gpp.encoder.field.UspV1Field;
import com.iab.gpp.encoder.section.AbstractEncodableSegmentedBitStringSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class UspCaV1
extends AbstractEncodableSegmentedBitStringSection {
    public static int ID = 8;
    public static int VERSION = 1;
    public static String NAME = "uspcav1";
    private AbstractBase64UrlEncoder base64UrlEncoder = new CompressedBase64UrlEncoder();

    public UspCaV1() {
        this.initFields();
    }

    public UspCaV1(String encodedString) throws DecodingException {
        this.initFields();
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    private void initFields() {
        this.fields = new HashMap();
        this.fields.put(UspCaV1Field.VERSION, new EncodableFixedInteger(6, VERSION));
        this.fields.put(UspCaV1Field.SALE_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.SHARING_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.SALE_OPT_OUT, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.SHARING_OPT_OUT, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.SENSITIVE_DATA_PROCESSING, new EncodableFixedIntegerList(2, Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0)));
        this.fields.put(UspCaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, new EncodableFixedIntegerList(2, Arrays.asList(0, 0)));
        this.fields.put(UspCaV1Field.PERSONAL_DATA_CONSENTS, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.MSPA_COVERED_TRANSACTION, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.MSPA_OPT_OUT_OPTION_MODE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.MSPA_SERVICE_PROVIDER_MODE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspCaV1Field.GPC_SEGMENT_TYPE, new EncodableFixedInteger(2, 1));
        this.fields.put(UspCaV1Field.GPC_SEGMENT_INCLUDED, new EncodableBoolean(true));
        this.fields.put(UspCaV1Field.GPC, new EncodableBoolean(false));
        String[] coreSegment = new String[]{UspCaV1Field.VERSION, UspCaV1Field.SALE_OPT_OUT_NOTICE, UspCaV1Field.SHARING_OPT_OUT_NOTICE, UspCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE, UspCaV1Field.SALE_OPT_OUT, UspCaV1Field.SHARING_OPT_OUT, UspCaV1Field.SENSITIVE_DATA_PROCESSING, UspCaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, UspCaV1Field.PERSONAL_DATA_CONSENTS, UspCaV1Field.MSPA_COVERED_TRANSACTION, UspCaV1Field.MSPA_OPT_OUT_OPTION_MODE, UspCaV1Field.MSPA_SERVICE_PROVIDER_MODE};
        String[] gpcSegment = new String[]{UspCaV1Field.GPC_SEGMENT_TYPE, UspCaV1Field.GPC};
        this.segments = new String[][]{coreSegment, gpcSegment};
    }

    @Override
    public String encode() throws EncodingException {
        List<String> segmentBitStrings = this.encodeSegmentsToBitStrings();
        ArrayList<String> encodedSegments = new ArrayList<String>();
        if (segmentBitStrings.size() >= 1) {
            Boolean gpcSegmentIncluded;
            encodedSegments.add(this.base64UrlEncoder.encode(segmentBitStrings.get(0)));
            if (segmentBitStrings.size() >= 2 && (gpcSegmentIncluded = (Boolean)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.GPC_SEGMENT_INCLUDED)).getValue()).booleanValue()) {
                encodedSegments.add(this.base64UrlEncoder.encode(segmentBitStrings.get(1)));
            }
        }
        return encodedSegments.stream().collect(Collectors.joining("."));
    }

    @Override
    public void decode(String encodedSection) throws DecodingException {
        String[] encodedSegments = encodedSection.split("\\.");
        String[] segmentBitStrings = new String[2];
        boolean gpcSegmentIncluded = false;
        block8: for (int i = 0; i < encodedSegments.length; ++i) {
            String segmentBitString = this.base64UrlEncoder.decode(encodedSegments[i]);
            switch (segmentBitString.substring(0, 2)) {
                case "00": {
                    segmentBitStrings[0] = segmentBitString;
                    continue block8;
                }
                case "01": {
                    gpcSegmentIncluded = true;
                    segmentBitStrings[1] = segmentBitString;
                    continue block8;
                }
                default: {
                    throw new DecodingException("Unable to decode segment '" + encodedSegments[i] + "'");
                }
            }
        }
        this.decodeSegmentsFromBitStrings(Arrays.asList(segmentBitStrings));
        ((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.GPC_SEGMENT_INCLUDED)).setValue(gpcSegmentIncluded);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Integer getVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspV1Field.VERSION)).getValue();
    }

    public Integer getSaleOptOutNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SALE_OPT_OUT_NOTICE)).getValue();
    }

    public Integer getSensitiveDataLimitUseNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE)).getValue();
    }

    public Integer getSharingOptOutNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SHARING_OPT_OUT_NOTICE)).getValue();
    }

    public Integer getSaleOptOut() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SALE_OPT_OUT)).getValue();
    }

    public Integer getSharingOptOut() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SHARING_OPT_OUT)).getValue();
    }

    public List<Integer> getSensitiveDataProcessing() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.SENSITIVE_DATA_PROCESSING)).getValue();
    }

    public List<Integer> getKnownChildSensitiveDataConsents() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS)).getValue();
    }

    public Integer getPersonalDataConsents() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.PERSONAL_DATA_CONSENTS)).getValue();
    }

    public Integer getMspaCoveredTransaction() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.MSPA_COVERED_TRANSACTION)).getValue();
    }

    public Integer getMspaOptOutOptionMode() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.MSPA_OPT_OUT_OPTION_MODE)).getValue();
    }

    public Integer getMspaServiceProviderMode() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.MSPA_SERVICE_PROVIDER_MODE)).getValue();
    }

    public Boolean getGpcSegmentType() {
        return (Boolean)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.GPC_SEGMENT_TYPE)).getValue();
    }

    public Boolean getGpcSegmentIncluded() {
        return (Boolean)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.GPC_SEGMENT_INCLUDED)).getValue();
    }

    public Boolean getGpc() {
        return (Boolean)((AbstractEncodableBitStringDataType)this.fields.get(UspCaV1Field.GPC)).getValue();
    }
}

