/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.UspV1LegacyField;
import com.iab.gpp.encoder.section.EncodableSection;
import java.util.HashMap;
import java.util.Map;

public class UspV1
implements EncodableSection {
    public static int ID = 6;
    public static int VERSION = 1;
    public static String NAME = "uspv1";
    protected Map<String, Object> fields;

    public UspV1() {
        this.initFields();
    }

    public UspV1(String encodedString) throws DecodingException {
        this.initFields();
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    private void initFields() {
        this.fields = new HashMap<String, Object>();
        this.fields.put(UspV1LegacyField.VERSION, VERSION);
        this.fields.put(UspV1LegacyField.NOTICE, "-");
        this.fields.put(UspV1LegacyField.OPT_OUT_SALE, "-");
        this.fields.put(UspV1LegacyField.LSPA_COVERED, "-");
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    @Override
    public Object getFieldValue(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName);
        }
        return null;
    }

    @Override
    public void setFieldValue(String fieldName, Object value) throws InvalidFieldException {
        if (!this.fields.containsKey(fieldName)) {
            throw new InvalidFieldException(fieldName + " not found");
        }
        this.fields.put(fieldName, value);
    }

    @Override
    public String encode() throws EncodingException {
        String str = "";
        str = str + this.getFieldValue(UspV1LegacyField.VERSION);
        str = str + this.getFieldValue(UspV1LegacyField.NOTICE);
        str = str + this.getFieldValue(UspV1LegacyField.OPT_OUT_SALE);
        str = str + this.getFieldValue(UspV1LegacyField.LSPA_COVERED);
        return str;
    }

    @Override
    public void decode(String encodedString) throws DecodingException {
        try {
            this.setFieldValue(UspV1LegacyField.VERSION, Integer.parseInt(String.valueOf(encodedString.charAt(0))));
            this.setFieldValue(UspV1LegacyField.NOTICE, String.valueOf(encodedString.charAt(1)));
            this.setFieldValue(UspV1LegacyField.OPT_OUT_SALE, String.valueOf(encodedString.charAt(2)));
            this.setFieldValue(UspV1LegacyField.LSPA_COVERED, String.valueOf(encodedString.charAt(3)));
        }
        catch (InvalidFieldException e) {
            throw new DecodingException(e);
        }
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Integer getVersion() {
        return (Integer)this.fields.get(UspV1LegacyField.VERSION);
    }

    public String getNotice() {
        return (String)this.fields.get(UspV1LegacyField.NOTICE);
    }

    public String getOptOutSale() {
        return (String)this.fields.get(UspV1LegacyField.OPT_OUT_SALE);
    }

    public String getLspaCovered() {
        return (String)this.fields.get(UspV1LegacyField.LSPA_COVERED);
    }
}

