/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerList;
import com.iab.gpp.encoder.datatype.encoder.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.datatype.encoder.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.field.UspV1Field;
import com.iab.gpp.encoder.field.UspVaV1Field;
import com.iab.gpp.encoder.section.AbstractEncodableBitStringSection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class UspVaV1
extends AbstractEncodableBitStringSection {
    public static int ID = 9;
    public static int VERSION = 1;
    public static String NAME = "uspvav1";
    private AbstractBase64UrlEncoder base64UrlEncoder = new CompressedBase64UrlEncoder();

    public UspVaV1() {
        this.initFields();
    }

    public UspVaV1(String encodedString) throws DecodingException {
        this.initFields();
        if (encodedString != null && encodedString.length() > 0) {
            this.decode(encodedString);
        }
    }

    private void initFields() {
        this.fields = new HashMap();
        this.fields.put(UspVaV1Field.VERSION, new EncodableFixedInteger(6, VERSION));
        this.fields.put(UspVaV1Field.SHARING_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.SALE_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.SALE_OPT_OUT, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.SENSITIVE_DATA_PROCESSING, new EncodableFixedIntegerList(2, Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0)));
        this.fields.put(UspVaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.MSPA_COVERED_TRANSACTION, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.MSPA_OPT_OUT_OPTION_MODE, new EncodableFixedInteger(2, 0));
        this.fields.put(UspVaV1Field.MSPA_SERVICE_PROVIDER_MODE, new EncodableFixedInteger(2, 0));
        this.fieldOrder = new String[]{UspVaV1Field.VERSION, UspVaV1Field.SHARING_NOTICE, UspVaV1Field.SALE_OPT_OUT_NOTICE, UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT_NOTICE, UspVaV1Field.SALE_OPT_OUT, UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT, UspVaV1Field.SENSITIVE_DATA_PROCESSING, UspVaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, UspVaV1Field.MSPA_COVERED_TRANSACTION, UspVaV1Field.MSPA_OPT_OUT_OPTION_MODE, UspVaV1Field.MSPA_SERVICE_PROVIDER_MODE};
    }

    @Override
    public String encode() throws EncodingException {
        String bitString = this.encodeToBitString();
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    public void decode(String encodedString) throws DecodingException {
        String bitString = this.base64UrlEncoder.decode(encodedString);
        this.decodeFromBitString(bitString);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Integer getVersion() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspV1Field.VERSION)).getValue();
    }

    public Integer getSharingNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.SHARING_NOTICE)).getValue();
    }

    public Integer getSaleOptOutNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.SALE_OPT_OUT_NOTICE)).getValue();
    }

    public Integer getTargetedAdvertisingOptOutNotice() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT_NOTICE)).getValue();
    }

    public Integer getSaleOptOut() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.SALE_OPT_OUT)).getValue();
    }

    public Integer getTargetedAdvertisingOptOut() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.TARGETED_ADVERTISING_OPT_OUT)).getValue();
    }

    public List<Integer> getSensitiveDataProcessing() {
        return (List)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.SENSITIVE_DATA_PROCESSING)).getValue();
    }

    public Integer getKnownChildSensitiveDataConsents() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS)).getValue();
    }

    public Integer getMspaCoveredTransaction() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.MSPA_COVERED_TRANSACTION)).getValue();
    }

    public Integer getMspaOptOutOptionMode() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.MSPA_OPT_OUT_OPTION_MODE)).getValue();
    }

    public Integer getMspaServiceProviderMode() {
        return (Integer)((AbstractEncodableBitStringDataType)this.fields.get(UspVaV1Field.MSPA_SERVICE_PROVIDER_MODE)).getValue();
    }
}

