/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder;

import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.HeaderV1Field;
import com.iab.gpp.encoder.section.AbstractLazilyEncodableSection;
import com.iab.gpp.encoder.section.EncodableSection;
import com.iab.gpp.encoder.section.HeaderV1;
import com.iab.gpp.encoder.section.Sections;
import com.iab.gpp.encoder.section.TcfCaV1;
import com.iab.gpp.encoder.section.TcfEuV2;
import com.iab.gpp.encoder.section.UsCaV1;
import com.iab.gpp.encoder.section.UsCoV1;
import com.iab.gpp.encoder.section.UsCtV1;
import com.iab.gpp.encoder.section.UsNatV1;
import com.iab.gpp.encoder.section.UsUtV1;
import com.iab.gpp.encoder.section.UsVaV1;
import com.iab.gpp.encoder.section.UspV1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GppModel {
    private Map<String, EncodableSection> sections = new HashMap<String, EncodableSection>();
    private String encodedString;
    private boolean dirty = false;
    private boolean decoded = true;

    public GppModel() {
    }

    public GppModel(String encodedString) {
        this.decode(encodedString);
    }

    public void setFieldValue(int sectionId, String fieldName, Object value) {
        this.setFieldValue(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName, value);
    }

    public void setFieldValue(String sectionName, String fieldName, Object value) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        EncodableSection section = null;
        if (!this.sections.containsKey(sectionName)) {
            if (sectionName.equals(TcfCaV1.NAME)) {
                section = new TcfCaV1();
                this.sections.put(TcfCaV1.NAME, section);
            } else if (sectionName.equals(TcfEuV2.NAME)) {
                section = new TcfEuV2();
                this.sections.put(TcfEuV2.NAME, section);
            } else if (sectionName.equals(UspV1.NAME)) {
                section = new UspV1();
                this.sections.put(UspV1.NAME, section);
            } else if (sectionName.equals(UsNatV1.NAME)) {
                section = new UsNatV1();
                this.sections.put(UsNatV1.NAME, section);
            } else if (sectionName.equals(UsCaV1.NAME)) {
                section = new UsCaV1();
                this.sections.put(UsCaV1.NAME, section);
            } else if (sectionName.equals(UsVaV1.NAME)) {
                section = new UsVaV1();
                this.sections.put(UsVaV1.NAME, section);
            } else if (sectionName.equals(UsCoV1.NAME)) {
                section = new UsCoV1();
                this.sections.put(UsCoV1.NAME, section);
            } else if (sectionName.equals(UsUtV1.NAME)) {
                section = new UsUtV1();
                this.sections.put(UsUtV1.NAME, section);
            } else if (sectionName.equals(UsCtV1.NAME)) {
                section = new UsCtV1();
                this.sections.put(UsCtV1.NAME, section);
            }
        } else {
            section = this.sections.get(sectionName);
        }
        if (section == null) {
            throw new InvalidFieldException(sectionName + "." + fieldName + " not found");
        }
        section.setFieldValue(fieldName, value);
        this.dirty = true;
    }

    public Object getFieldValue(int sectionId, String fieldName) {
        return this.getFieldValue(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName);
    }

    public Object getFieldValue(String sectionName, String fieldName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).getFieldValue(fieldName);
        }
        return null;
    }

    public boolean hasField(int sectionId, String fieldName) {
        return this.hasField(Sections.SECTION_ID_NAME_MAP.get(sectionId), fieldName);
    }

    public boolean hasField(String sectionName, String fieldName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).hasField(fieldName);
        }
        return false;
    }

    public boolean hasSection(int sectionId) {
        return this.hasSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public boolean hasSection(String sectionName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        return this.sections.containsKey(sectionName);
    }

    public HeaderV1 getHeader() {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        HeaderV1 header = new HeaderV1();
        try {
            header.setFieldValue("SectionIds", this.getSectionIds());
        }
        catch (InvalidFieldException invalidFieldException) {
            // empty catch block
        }
        return header;
    }

    public EncodableSection getSection(int sectionId) {
        return this.getSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public EncodableSection getSection(String sectionName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName);
        }
        return null;
    }

    public void deleteSection(int sectionId) {
        this.deleteSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public void deleteSection(String sectionName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.sections.containsKey(sectionName)) {
            this.sections.remove(sectionName);
            this.dirty = true;
        }
    }

    public void clear() {
        this.sections.clear();
        this.encodedString = null;
        this.dirty = false;
        this.decoded = true;
    }

    public TcfCaV1 getTcfCaV1Section() {
        return (TcfCaV1)this.getSection(TcfCaV1.NAME);
    }

    public TcfEuV2 getTcfEuV2Section() {
        return (TcfEuV2)this.getSection(TcfEuV2.NAME);
    }

    public UspV1 getUspV1Section() {
        return (UspV1)this.getSection(UspV1.NAME);
    }

    public UsNatV1 getUsNatV1Section() {
        return (UsNatV1)this.getSection(UsNatV1.NAME);
    }

    public UsCaV1 getUsCaV1Section() {
        return (UsCaV1)this.getSection(UsCaV1.NAME);
    }

    public UsVaV1 getUsVaV1Section() {
        return (UsVaV1)this.getSection(UsVaV1.NAME);
    }

    public UsCoV1 getUsCoV1Section() {
        return (UsCoV1)this.getSection(UsCoV1.NAME);
    }

    public UsUtV1 getUsUtV1Section() {
        return (UsUtV1)this.getSection(UsUtV1.NAME);
    }

    public UsCtV1 getUsCtV1Section() {
        return (UsCtV1)this.getSection(UsCtV1.NAME);
    }

    public List<Integer> getSectionIds() {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        ArrayList<Integer> sectionIds = new ArrayList<Integer>();
        for (int i = 0; i < Sections.SECTION_ORDER.size(); ++i) {
            String sectionName = Sections.SECTION_ORDER.get(i);
            if (!this.sections.containsKey(sectionName)) continue;
            EncodableSection section = this.sections.get(sectionName);
            sectionIds.add(section.getId());
        }
        return sectionIds;
    }

    protected String encodeModel(Map<String, EncodableSection> sections) {
        ArrayList<String> encodedSections = new ArrayList<String>();
        ArrayList<Integer> sectionIds = new ArrayList<Integer>();
        for (int i = 0; i < Sections.SECTION_ORDER.size(); ++i) {
            String sectionName = Sections.SECTION_ORDER.get(i);
            if (!sections.containsKey(sectionName)) continue;
            EncodableSection section = sections.get(sectionName);
            encodedSections.add(section.encode());
            sectionIds.add(section.getId());
        }
        HeaderV1 header = new HeaderV1();
        try {
            header.setFieldValue("SectionIds", this.getSectionIds());
        }
        catch (InvalidFieldException e) {
            throw new EncodingException(e);
        }
        encodedSections.add(0, header.encode());
        String encodedString = encodedSections.stream().collect(Collectors.joining("~"));
        return encodedString;
    }

    protected Map<String, EncodableSection> decodeModel(String str) {
        if (str == null || str.isEmpty() || str.startsWith("D")) {
            HashMap<String, EncodableSection> sections = new HashMap<String, EncodableSection>();
            if (str != null && !str.isEmpty()) {
                String[] encodedSections = str.split("~");
                HeaderV1 header = new HeaderV1(encodedSections[0]);
                sections.put(HeaderV1.NAME, header);
                List sectionIds = (List)header.getFieldValue("SectionIds");
                for (int i = 0; i < sectionIds.size(); ++i) {
                    AbstractLazilyEncodableSection section;
                    if (((Integer)sectionIds.get(i)).equals(TcfEuV2.ID)) {
                        section = new TcfEuV2(encodedSections[i + 1]);
                        sections.put(TcfEuV2.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(TcfCaV1.ID)) {
                        section = new TcfCaV1(encodedSections[i + 1]);
                        sections.put(TcfCaV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UspV1.ID)) {
                        section = new UspV1(encodedSections[i + 1]);
                        sections.put(UspV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UsCaV1.ID)) {
                        section = new UsCaV1(encodedSections[i + 1]);
                        sections.put(UsCaV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UsNatV1.ID)) {
                        section = new UsNatV1(encodedSections[i + 1]);
                        sections.put(UsNatV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UsVaV1.ID)) {
                        section = new UsVaV1(encodedSections[i + 1]);
                        sections.put(UsVaV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UsCoV1.ID)) {
                        section = new UsCoV1(encodedSections[i + 1]);
                        sections.put(UsCoV1.NAME, section);
                        continue;
                    }
                    if (((Integer)sectionIds.get(i)).equals(UsUtV1.ID)) {
                        section = new UsUtV1(encodedSections[i + 1]);
                        sections.put(UsUtV1.NAME, section);
                        continue;
                    }
                    if (!((Integer)sectionIds.get(i)).equals(UsCtV1.ID)) continue;
                    section = new UsCtV1(encodedSections[i + 1]);
                    sections.put(UsCtV1.NAME, section);
                }
            }
            return sections;
        }
        if (str.startsWith("C")) {
            HashMap<String, EncodableSection> sections = new HashMap<String, EncodableSection>();
            TcfEuV2 section = new TcfEuV2(str);
            sections.put(TcfEuV2.NAME, section);
            HeaderV1 header = new HeaderV1();
            header.setFieldValue(HeaderV1Field.SECTION_IDS, Arrays.asList(2));
            sections.put(HeaderV1.NAME, section);
            return sections;
        }
        throw new DecodingException("Unable to decode '" + str + "'");
    }

    public String encodeSection(int sectionId) {
        return this.encodeSection(Sections.SECTION_ID_NAME_MAP.get(sectionId));
    }

    public String encodeSection(String sectionName) {
        if (!this.decoded) {
            this.sections = this.decodeModel(this.encodedString);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.sections.containsKey(sectionName)) {
            return this.sections.get(sectionName).encode();
        }
        return null;
    }

    public void decodeSection(int sectionId, String encodedString) {
        this.decodeSection(Sections.SECTION_ID_NAME_MAP.get(sectionId), encodedString);
    }

    public void decodeSection(String sectionName, String encodedString) {
        EncodableSection section = null;
        if (!this.sections.containsKey(sectionName)) {
            if (sectionName.equals(TcfEuV2.NAME)) {
                section = new TcfEuV2();
                this.sections.put(TcfEuV2.NAME, section);
            } else if (sectionName.equals(TcfCaV1.NAME)) {
                section = new TcfCaV1();
                this.sections.put(TcfCaV1.NAME, section);
            } else if (sectionName.equals(UspV1.NAME)) {
                section = new UspV1();
                this.sections.put(UspV1.NAME, section);
            } else if (sectionName.equals(UsNatV1.NAME)) {
                section = new UsNatV1();
                this.sections.put(UsNatV1.NAME, section);
            } else if (sectionName.equals(UsCaV1.NAME)) {
                section = new UsCaV1();
                this.sections.put(UsCaV1.NAME, section);
            } else if (sectionName.equals(UsVaV1.NAME)) {
                section = new UsVaV1();
                this.sections.put(UsVaV1.NAME, section);
            } else if (sectionName.equals(UsCoV1.NAME)) {
                section = new UsCoV1();
                this.sections.put(UsCoV1.NAME, section);
            } else if (sectionName.equals(UsUtV1.NAME)) {
                section = new UsUtV1();
                this.sections.put(UsUtV1.NAME, section);
            } else if (sectionName.equals(UsCtV1.NAME)) {
                section = new UsCtV1();
                this.sections.put(UsCtV1.NAME, section);
            }
        } else {
            section = this.sections.get(sectionName);
        }
        if (section != null) {
            section.decode(encodedString);
        }
    }

    public String encode() {
        if (this.encodedString == null || this.encodedString.isEmpty() || this.dirty) {
            this.encodedString = this.encodeModel(this.sections);
            this.dirty = false;
            this.decoded = true;
        }
        return this.encodedString;
    }

    public void decode(String encodedString) {
        this.encodedString = encodedString;
        this.dirty = false;
        this.decoded = false;
    }
}

