/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.bitstring;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.DataType;
import com.iab.gpp.encoder.datatype.SubstringException;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import java.util.List;

public class BitStringEncoder {
    private static BitStringEncoder instance = new BitStringEncoder();

    private BitStringEncoder() {
    }

    public static BitStringEncoder getInstance() {
        return instance;
    }

    public String encode(EncodableBitStringFields fields, List<String> fieldNames) {
        String bitString = "";
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            if (!fields.containsKey(fieldName)) {
                throw new EncodingException("Field not found: '" + fieldName + "'");
            }
            DataType field = fields.get(fieldName);
            bitString = bitString + ((AbstractEncodableBitStringDataType)field).encode();
        }
        return bitString;
    }

    public void decode(String bitString, List<String> fieldNames, EncodableBitStringFields fields) {
        int index = 0;
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = fieldNames.get(i);
            if (fields.containsKey(fieldName)) {
                DataType field = fields.get(fieldName);
                try {
                    String substring = ((AbstractEncodableBitStringDataType)field).substring(bitString, index);
                    ((AbstractEncodableBitStringDataType)field).decode(substring);
                    index += substring.length();
                    continue;
                }
                catch (SubstringException e) {
                    if (((AbstractEncodableBitStringDataType)field).getHardFailIfMissing()) {
                        throw new DecodingException("Unable to decode " + fieldName, e);
                    }
                    return;
                }
                catch (Exception e) {
                    throw new DecodingException("Unable to decode " + fieldName, e);
                }
            }
            throw new DecodingException("Field not found: '" + fieldName + "'");
        }
    }
}

