/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.EncodableDataType;
import com.iab.gpp.encoder.datatype.SubstringException;
import com.iab.gpp.encoder.error.ValidationException;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractEncodableBitStringDataType<T>
implements EncodableDataType<T> {
    protected boolean hardFailIfMissing = true;
    protected Predicate<T> validator = null;
    protected T value;

    protected AbstractEncodableBitStringDataType(boolean hardFailIfMissing) {
        this.hardFailIfMissing = hardFailIfMissing;
    }

    public AbstractEncodableBitStringDataType<T> withValidator(Predicate<T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        Object v = value;
        if (this.validator != null && !this.validator.test(v)) {
            if (v instanceof Collection) {
                throw new ValidationException("Invalid value '" + ((Collection)v).stream().map(i -> i.toString()).collect(Collectors.joining(",")) + "'");
            }
            throw new ValidationException("Invalid value '" + v + "'");
        }
        this.value = v;
    }

    public boolean getHardFailIfMissing() {
        return this.hardFailIfMissing;
    }

    @Override
    public abstract String encode();

    @Override
    public abstract void decode(String var1);

    public abstract String substring(String var1, int var2) throws SubstringException;
}

