/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.SubstringException;
import com.iab.gpp.encoder.datatype.encoder.FixedBitfieldEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncodableFixedBitfield
extends AbstractEncodableBitStringDataType<List<Boolean>> {
    private int numElements;

    protected EncodableFixedBitfield(int numElements) {
        super(true);
        this.numElements = numElements;
    }

    protected EncodableFixedBitfield(int numElements, boolean hardFailIfMissing) {
        super(hardFailIfMissing);
        this.numElements = numElements;
    }

    public EncodableFixedBitfield(List<Boolean> value) {
        super(true);
        this.numElements = value.size();
        this.setValue(value);
    }

    public EncodableFixedBitfield(List<Boolean> value, boolean hardFailIfMissing) {
        super(hardFailIfMissing);
        this.numElements = value.size();
        this.setValue(value);
    }

    @Override
    public String encode() {
        try {
            return FixedBitfieldEncoder.encode((List)this.value, this.numElements);
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public void decode(String bitString) {
        try {
            this.value = FixedBitfieldEncoder.decode(bitString);
        }
        catch (Exception e) {
            throw new DecodingException(e);
        }
    }

    @Override
    public String substring(String bitString, int fromIndex) throws SubstringException {
        try {
            return bitString.substring(fromIndex, fromIndex + this.numElements);
        }
        catch (Exception e) {
            throw new SubstringException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        List<Boolean> v = new ArrayList<Boolean>((List)value);
        for (int i = v.size(); i < this.numElements; ++i) {
            v.add(false);
        }
        if (v.size() > this.numElements) {
            v = v.subList(0, this.numElements);
        }
        super.setValue(v);
    }

    @Override
    public List<Boolean> getValue() {
        return new ArrayList<Boolean>((Collection)super.getValue());
    }
}

