/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.SubstringException;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerRangeEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class EncodableFixedIntegerRange
extends AbstractEncodableBitStringDataType<List<Integer>> {
    protected EncodableFixedIntegerRange() {
        super(true);
    }

    public EncodableFixedIntegerRange(List<Integer> value) {
        super(true);
        this.setValue(value);
    }

    public EncodableFixedIntegerRange(List<Integer> value, boolean hardFailIfMissing) {
        super(hardFailIfMissing);
        this.setValue(value);
    }

    @Override
    public String encode() {
        try {
            return FixedIntegerRangeEncoder.encode((List)this.value);
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public void decode(String bitString) {
        try {
            this.value = FixedIntegerRangeEncoder.decode(bitString);
        }
        catch (Exception e) {
            throw new DecodingException(e);
        }
    }

    @Override
    public String substring(String bitString, int fromIndex) throws SubstringException {
        try {
            int count = FixedIntegerEncoder.decode(bitString.substring(fromIndex, fromIndex + 12));
            int index = fromIndex + 12;
            for (int i = 0; i < count; ++i) {
                if (bitString.charAt(index) == '1') {
                    index += 33;
                    continue;
                }
                index += 17;
            }
            return bitString.substring(fromIndex, index);
        }
        catch (Exception e) {
            throw new SubstringException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(new ArrayList(new TreeSet((List)value)));
    }

    @Override
    public List<Integer> getValue() {
        return new ArrayList<Integer>((Collection)super.getValue());
    }
}

