/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.error.DecodingException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FibonacciIntegerEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(int value) {
        ArrayList<Integer> fib = new ArrayList<Integer>();
        if (value >= 1) {
            fib.add(1);
            if (value >= 2) {
                fib.add(2);
                int i = 2;
                while (value >= (Integer)fib.get(i - 1) + (Integer)fib.get(i - 2)) {
                    fib.add((Integer)fib.get(i - 1) + (Integer)fib.get(i - 2));
                    ++i;
                }
            }
        }
        String bitString = "1";
        for (int i = fib.size() - 1; i >= 0; --i) {
            int f = (Integer)fib.get(i);
            if (value >= f) {
                bitString = "1" + bitString;
                value -= f;
                continue;
            }
            bitString = "0" + bitString;
        }
        return bitString;
    }

    public static int decode(String bitString) throws DecodingException {
        int i;
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() < 2 || bitString.indexOf("11") != bitString.length() - 2) {
            throw new DecodingException("Undecodable FibonacciInteger '" + bitString + "'");
        }
        int value = 0;
        ArrayList<Integer> fib = new ArrayList<Integer>();
        for (i = 0; i < bitString.length() - 1; ++i) {
            if (i == 0) {
                fib.add(1);
                continue;
            }
            if (i == 1) {
                fib.add(2);
                continue;
            }
            fib.add((Integer)fib.get(i - 1) + (Integer)fib.get(i - 2));
        }
        for (i = 0; i < bitString.length() - 1; ++i) {
            if (bitString.charAt(i) != '1') continue;
            value += ((Integer)fib.get(i)).intValue();
        }
        return value;
    }
}

