/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.section;

import com.iab.gpp.encoder.field.UsCaV1Field;
import com.iab.gpp.encoder.section.AbstractLazilyEncodableSection;
import com.iab.gpp.encoder.segment.EncodableSegment;
import com.iab.gpp.encoder.segment.UsCaV1CoreSegment;
import com.iab.gpp.encoder.segment.UsCaV1GpcSegment;
import java.util.ArrayList;
import java.util.List;

public class UsCaV1
extends AbstractLazilyEncodableSection {
    public static int ID = 8;
    public static int VERSION = 1;
    public static String NAME = "uscav1";

    public UsCaV1() {
    }

    public UsCaV1(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    @Override
    protected List<EncodableSegment> initializeSegments() {
        ArrayList<EncodableSegment> segments = new ArrayList<EncodableSegment>();
        segments.add(new UsCaV1CoreSegment());
        segments.add(new UsCaV1GpcSegment());
        return segments;
    }

    @Override
    protected List<EncodableSegment> decodeSection(String encodedString) {
        List<EncodableSegment> segments = this.initializeSegments();
        if (encodedString != null && !encodedString.isEmpty()) {
            String[] encodedSegments = encodedString.split("\\.");
            if (encodedSegments.length > 0) {
                segments.get(0).decode(encodedSegments[0]);
            }
            if (encodedSegments.length > 1) {
                segments.get(1).setFieldValue(UsCaV1Field.GPC_SEGMENT_INCLUDED, true);
                segments.get(1).decode(encodedSegments[1]);
            } else {
                segments.get(1).setFieldValue(UsCaV1Field.GPC_SEGMENT_INCLUDED, false);
            }
        }
        return segments;
    }

    @Override
    protected String encodeSection(List<EncodableSegment> segments) {
        ArrayList<String> encodedSegments = new ArrayList<String>();
        if (!segments.isEmpty()) {
            encodedSegments.add(segments.get(0).encode());
            if (segments.size() >= 2 && segments.get(1).getFieldValue(UsCaV1Field.GPC_SEGMENT_INCLUDED).equals(true)) {
                encodedSegments.add(segments.get(1).encode());
            }
        }
        return String.join((CharSequence)".", encodedSegments);
    }

    public Integer getSaleOptOutNotice() {
        return (Integer)this.getFieldValue(UsCaV1Field.SALE_OPT_OUT_NOTICE);
    }

    public Integer getSensitiveDataLimitUseNotice() {
        return (Integer)this.getFieldValue(UsCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE);
    }

    public Integer getSharingOptOutNotice() {
        return (Integer)this.getFieldValue(UsCaV1Field.SHARING_OPT_OUT_NOTICE);
    }

    public Integer getSaleOptOut() {
        return (Integer)this.getFieldValue(UsCaV1Field.SALE_OPT_OUT);
    }

    public Integer getSharingOptOut() {
        return (Integer)this.getFieldValue(UsCaV1Field.SHARING_OPT_OUT);
    }

    public List<Integer> getSensitiveDataProcessing() {
        return (List)this.getFieldValue(UsCaV1Field.SENSITIVE_DATA_PROCESSING);
    }

    public List<Integer> getKnownChildSensitiveDataConsents() {
        return (List)this.getFieldValue(UsCaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS);
    }

    public Integer getPersonalDataConsents() {
        return (Integer)this.getFieldValue(UsCaV1Field.PERSONAL_DATA_CONSENTS);
    }

    public Integer getMspaCoveredTransaction() {
        return (Integer)this.getFieldValue(UsCaV1Field.MSPA_COVERED_TRANSACTION);
    }

    public Integer getMspaOptOutOptionMode() {
        return (Integer)this.getFieldValue(UsCaV1Field.MSPA_OPT_OUT_OPTION_MODE);
    }

    public Integer getMspaServiceProviderMode() {
        return (Integer)this.getFieldValue(UsCaV1Field.MSPA_SERVICE_PROVIDER_MODE);
    }

    public Integer getGpcSegmentType() {
        return (Integer)this.getFieldValue(UsCaV1Field.GPC_SEGMENT_TYPE);
    }

    public Boolean getGpcSegmentIncluded() {
        return (Boolean)this.getFieldValue(UsCaV1Field.GPC_SEGMENT_INCLUDED);
    }

    public Boolean getGpc() {
        return (Boolean)this.getFieldValue(UsCaV1Field.GPC);
    }
}

