/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.error.InvalidFieldException;
import com.iab.gpp.encoder.field.Fields;
import com.iab.gpp.encoder.segment.EncodableSegment;

public abstract class AbstractLazilyEncodableSegment<T extends Fields<?>>
implements EncodableSegment {
    protected T fields = this.initializeFields();
    private String encodedString = null;
    private boolean dirty = false;
    private boolean decoded = true;

    protected abstract T initializeFields();

    protected abstract String encodeSegment(T var1);

    protected abstract void decodeSegment(String var1, T var2);

    @Override
    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    @Override
    public Object getFieldValue(String fieldName) {
        if (!this.decoded) {
            this.decodeSegment(this.encodedString, this.fields);
            this.dirty = false;
            this.decoded = true;
        }
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName).getValue();
        }
        throw new InvalidFieldException("Invalid field: '" + fieldName + "'");
    }

    @Override
    public void setFieldValue(String fieldName, Object value) {
        if (!this.decoded) {
            this.decodeSegment(this.encodedString, this.fields);
            this.dirty = false;
            this.decoded = true;
        }
        if (!this.fields.containsKey(fieldName)) {
            throw new InvalidFieldException(fieldName + " not found");
        }
        this.fields.get(fieldName).setValue(value);
        this.dirty = true;
    }

    @Override
    public String encode() {
        if (this.encodedString == null || this.encodedString.isEmpty() || this.dirty) {
            this.validate();
            this.encodedString = this.encodeSegment(this.fields);
            this.dirty = false;
            this.decoded = true;
        }
        return this.encodedString;
    }

    @Override
    public void decode(String encodedString) {
        this.encodedString = encodedString;
        this.dirty = false;
        this.decoded = false;
    }
}

