/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableFibonacciIntegerRange;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.HeaderV1Field;
import com.iab.gpp.encoder.section.HeaderV1;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.ArrayList;
import java.util.List;

public class HeaderV1CoreSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = CompressedBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public HeaderV1CoreSegment() {
    }

    public HeaderV1CoreSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return HeaderV1Field.HEADER_CORE_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(HeaderV1Field.ID, new EncodableFixedInteger(6, HeaderV1.ID));
        fields.put(HeaderV1Field.VERSION, new EncodableFixedInteger(6, HeaderV1.VERSION));
        fields.put(HeaderV1Field.SECTION_IDS, new EncodableFibonacciIntegerRange(new ArrayList<Integer>()));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode HeaderV1CoreSegment '" + encodedString + "'", e);
        }
    }
}

