/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerList;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.ValidationException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.UsCaV1Field;
import com.iab.gpp.encoder.section.UsCaV1;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class UsCaV1CoreSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = CompressedBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public UsCaV1CoreSegment() {
    }

    public UsCaV1CoreSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return UsCaV1Field.USCAV1_CORE_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        Predicate<Integer> nullableBooleanAsTwoBitIntegerValidator = n -> n >= 0 && n <= 2;
        Predicate<Integer> nonNullableBooleanAsTwoBitIntegerValidator = n -> n >= 1 && n <= 2;
        Predicate<List> nullableBooleanAsTwoBitIntegerListValidator = l -> {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n >= 0 && n <= 2) continue;
                return false;
            }
            return true;
        };
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(UsCaV1Field.VERSION, new EncodableFixedInteger(6, UsCaV1.VERSION));
        fields.put(UsCaV1Field.SALE_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.SHARING_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.SALE_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.SHARING_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.SENSITIVE_DATA_PROCESSING, new EncodableFixedIntegerList(2, Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0)).withValidator(nullableBooleanAsTwoBitIntegerListValidator));
        fields.put(UsCaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, new EncodableFixedIntegerList(2, Arrays.asList(0, 0)).withValidator(nullableBooleanAsTwoBitIntegerListValidator));
        fields.put(UsCaV1Field.PERSONAL_DATA_CONSENTS, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.MSPA_COVERED_TRANSACTION, new EncodableFixedInteger(2, 1).withValidator(nonNullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.MSPA_OPT_OUT_OPTION_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsCaV1Field.MSPA_SERVICE_PROVIDER_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode UsCaV1CoreSegment '" + encodedString + "'", e);
        }
    }

    @Override
    public void validate() {
        Integer sharingOptOutNotice = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.SHARING_OPT_OUT_NOTICE)).getValue();
        Integer sharingOptOut = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.SHARING_OPT_OUT)).getValue();
        Integer saleOptOutNotice = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.SALE_OPT_OUT_NOTICE)).getValue();
        Integer saleOptOut = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.SALE_OPT_OUT)).getValue();
        Integer mspaServiceProviderMode = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.MSPA_SERVICE_PROVIDER_MODE)).getValue();
        Integer mspaOptOutOptionMode = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.MSPA_OPT_OUT_OPTION_MODE)).getValue();
        Integer sensitiveDataLimtUserNotice = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsCaV1Field.SENSITIVE_DATA_LIMIT_USE_NOTICE)).getValue();
        if (sharingOptOutNotice == 0 ? sharingOptOut != 0 : (sharingOptOutNotice == 1 ? sharingOptOut != 1 && sharingOptOut != 2 : sharingOptOutNotice == 2 && sharingOptOut != 1)) {
            throw new ValidationException("Invalid usca sharing notice / opt out combination: {" + sharingOptOutNotice + " / " + sharingOptOut + "}");
        }
        if (saleOptOutNotice == 0 ? saleOptOut != 0 : (saleOptOutNotice == 1 ? saleOptOut != 1 && saleOptOut != 2 : saleOptOutNotice == 2 && saleOptOut != 1)) {
            throw new ValidationException("Invalid usca sale notice / opt out combination: {" + saleOptOutNotice + " / " + saleOptOut + "}");
        }
        if (mspaServiceProviderMode == 0) {
            if (saleOptOutNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sale opt out notice combination: {" + mspaServiceProviderMode + " / " + saleOptOutNotice + "}");
            }
            if (sharingOptOutNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sharing opt out notice combination: {" + mspaServiceProviderMode + " / " + sharingOptOutNotice + "}");
            }
            if (sensitiveDataLimtUserNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sensitive data limit use notice combination: {" + mspaServiceProviderMode + " / " + sensitiveDataLimtUserNotice + "}");
            }
        } else if (mspaServiceProviderMode == 1) {
            if (mspaOptOutOptionMode != 2) {
                throw new ValidationException("Invalid usca mspa service provider / opt out option modes combination: {" + mspaServiceProviderMode + " / " + mspaServiceProviderMode + "}");
            }
            if (saleOptOutNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sale opt out notice combination: {" + mspaServiceProviderMode + " / " + saleOptOutNotice + "}");
            }
            if (sharingOptOutNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sharing opt out notice combination: {" + mspaServiceProviderMode + " / " + sharingOptOutNotice + "}");
            }
            if (sensitiveDataLimtUserNotice != 0) {
                throw new ValidationException("Invalid usca mspa service provider mode / sensitive data limit use notice combination: {" + mspaServiceProviderMode + " / " + sensitiveDataLimtUserNotice + "}");
            }
        } else if (mspaServiceProviderMode == 2 && mspaOptOutOptionMode != 1) {
            throw new ValidationException("Invalid usca mspa service provider / opt out option modes combination: {" + mspaServiceProviderMode + " / " + mspaOptOutOptionMode + "}");
        }
    }
}

