/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.segment;

import com.iab.gpp.encoder.base64.AbstractBase64UrlEncoder;
import com.iab.gpp.encoder.base64.CompressedBase64UrlEncoder;
import com.iab.gpp.encoder.bitstring.BitStringEncoder;
import com.iab.gpp.encoder.datatype.EncodableFixedInteger;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerList;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.ValidationException;
import com.iab.gpp.encoder.field.EncodableBitStringFields;
import com.iab.gpp.encoder.field.UsVaV1Field;
import com.iab.gpp.encoder.section.UsVaV1;
import com.iab.gpp.encoder.segment.AbstractLazilyEncodableSegment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class UsVaV1CoreSegment
extends AbstractLazilyEncodableSegment<EncodableBitStringFields> {
    private AbstractBase64UrlEncoder base64UrlEncoder = CompressedBase64UrlEncoder.getInstance();
    private BitStringEncoder bitStringEncoder = BitStringEncoder.getInstance();

    public UsVaV1CoreSegment() {
    }

    public UsVaV1CoreSegment(String encodedString) {
        this.decode(encodedString);
    }

    @Override
    public List<String> getFieldNames() {
        return UsVaV1Field.USVAV1_CORE_SEGMENT_FIELD_NAMES;
    }

    @Override
    protected EncodableBitStringFields initializeFields() {
        Predicate<Integer> nullableBooleanAsTwoBitIntegerValidator = n -> n >= 0 && n <= 2;
        Predicate<Integer> nonNullableBooleanAsTwoBitIntegerValidator = n -> n >= 1 && n <= 2;
        Predicate<List> nullableBooleanAsTwoBitIntegerListValidator = l -> {
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n >= 0 && n <= 2) continue;
                return false;
            }
            return true;
        };
        EncodableBitStringFields fields = new EncodableBitStringFields();
        fields.put(UsVaV1Field.VERSION, new EncodableFixedInteger(6, UsVaV1.VERSION));
        fields.put(UsVaV1Field.SHARING_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.SALE_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.TARGETED_ADVERTISING_OPT_OUT_NOTICE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.SALE_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.TARGETED_ADVERTISING_OPT_OUT, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.SENSITIVE_DATA_PROCESSING, new EncodableFixedIntegerList(2, Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0)).withValidator(nullableBooleanAsTwoBitIntegerListValidator));
        fields.put(UsVaV1Field.KNOWN_CHILD_SENSITIVE_DATA_CONSENTS, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.MSPA_COVERED_TRANSACTION, new EncodableFixedInteger(2, 1).withValidator(nonNullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.MSPA_OPT_OUT_OPTION_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        fields.put(UsVaV1Field.MSPA_SERVICE_PROVIDER_MODE, new EncodableFixedInteger(2, 0).withValidator(nullableBooleanAsTwoBitIntegerValidator));
        return fields;
    }

    @Override
    protected String encodeSegment(EncodableBitStringFields fields) {
        String bitString = this.bitStringEncoder.encode(fields, this.getFieldNames());
        String encodedString = this.base64UrlEncoder.encode(bitString);
        return encodedString;
    }

    @Override
    protected void decodeSegment(String encodedString, EncodableBitStringFields fields) {
        if (encodedString == null || encodedString.isEmpty()) {
            ((EncodableBitStringFields)this.fields).reset(fields);
        }
        try {
            String bitString = this.base64UrlEncoder.decode(encodedString);
            this.bitStringEncoder.decode(bitString, this.getFieldNames(), fields);
        }
        catch (Exception e) {
            throw new DecodingException("Unable to decode UsVaV1CoreSegment '" + encodedString + "'", e);
        }
    }

    @Override
    public void validate() {
        Integer saleOptOutNotice = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.SALE_OPT_OUT_NOTICE)).getValue();
        Integer saleOptOut = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.SALE_OPT_OUT)).getValue();
        Integer targetedAdvertisingOptOutNotice = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.TARGETED_ADVERTISING_OPT_OUT_NOTICE)).getValue();
        Integer targetedAdvertisingOptOut = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.TARGETED_ADVERTISING_OPT_OUT)).getValue();
        Integer mspaServiceProviderMode = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.MSPA_SERVICE_PROVIDER_MODE)).getValue();
        Integer mspaOptOutOptionMode = (Integer)((EncodableFixedInteger)((EncodableBitStringFields)this.fields).get(UsVaV1Field.MSPA_OPT_OUT_OPTION_MODE)).getValue();
        if (saleOptOutNotice == 0 ? saleOptOut != 0 : (saleOptOutNotice == 1 ? saleOptOut != 1 && saleOptOut != 2 : saleOptOutNotice == 2 && saleOptOut != 1)) {
            throw new ValidationException("Invalid usva sale notice / opt out combination: {" + saleOptOutNotice + " / " + saleOptOut + "}");
        }
        if (targetedAdvertisingOptOutNotice == 0 ? targetedAdvertisingOptOut != 0 : (targetedAdvertisingOptOutNotice == 1 ? saleOptOut != 1 && saleOptOut != 2 : targetedAdvertisingOptOutNotice == 2 && saleOptOut != 1)) {
            throw new ValidationException("Invalid usva targeted advertising notice / opt out combination: {" + targetedAdvertisingOptOutNotice + " / " + targetedAdvertisingOptOut + "}");
        }
        if (mspaServiceProviderMode == 0) {
            if (saleOptOutNotice != 0) {
                throw new ValidationException("Invalid usva mspa service provider mode / sale opt out notice combination: {" + mspaServiceProviderMode + " / " + saleOptOutNotice + "}");
            }
        } else if (mspaServiceProviderMode == 1) {
            if (mspaOptOutOptionMode != 2) {
                throw new ValidationException("Invalid usva mspa service provider / opt out option modes combination: {" + mspaServiceProviderMode + " / " + mspaServiceProviderMode + "}");
            }
            if (saleOptOutNotice != 0) {
                throw new ValidationException("Invalid usva mspa service provider mode / sale opt out notice combination: {" + mspaServiceProviderMode + " / " + saleOptOutNotice + "}");
            }
        } else if (mspaServiceProviderMode == 2 && mspaOptOutOptionMode != 1) {
            throw new ValidationException("Invalid usva mspa service provider / opt out option modes combination: {" + mspaServiceProviderMode + " / " + mspaOptOutOptionMode + "}");
        }
    }
}

