/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.base64;

import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractBase64UrlEncoder {
    private static String DICT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    private static Map<Character, Integer> REVERSE_DICT = Stream.of({Character.valueOf('A'), 0}, {Character.valueOf('B'), 1}, {Character.valueOf('C'), 2}, {Character.valueOf('D'), 3}, {Character.valueOf('E'), 4}, {Character.valueOf('F'), 5}, {Character.valueOf('G'), 6}, {Character.valueOf('H'), 7}, {Character.valueOf('I'), 8}, {Character.valueOf('J'), 9}, {Character.valueOf('K'), 10}, {Character.valueOf('L'), 11}, {Character.valueOf('M'), 12}, {Character.valueOf('N'), 13}, {Character.valueOf('O'), 14}, {Character.valueOf('P'), 15}, {Character.valueOf('Q'), 16}, {Character.valueOf('R'), 17}, {Character.valueOf('S'), 18}, {Character.valueOf('T'), 19}, {Character.valueOf('U'), 20}, {Character.valueOf('V'), 21}, {Character.valueOf('W'), 22}, {Character.valueOf('X'), 23}, {Character.valueOf('Y'), 24}, {Character.valueOf('Z'), 25}, {Character.valueOf('a'), 26}, {Character.valueOf('b'), 27}, {Character.valueOf('c'), 28}, {Character.valueOf('d'), 29}, {Character.valueOf('e'), 30}, {Character.valueOf('f'), 31}, {Character.valueOf('g'), 32}, {Character.valueOf('h'), 33}, {Character.valueOf('i'), 34}, {Character.valueOf('j'), 35}, {Character.valueOf('k'), 36}, {Character.valueOf('l'), 37}, {Character.valueOf('m'), 38}, {Character.valueOf('n'), 39}, {Character.valueOf('o'), 40}, {Character.valueOf('p'), 41}, {Character.valueOf('q'), 42}, {Character.valueOf('r'), 43}, {Character.valueOf('s'), 44}, {Character.valueOf('t'), 45}, {Character.valueOf('u'), 46}, {Character.valueOf('v'), 47}, {Character.valueOf('w'), 48}, {Character.valueOf('x'), 49}, {Character.valueOf('y'), 50}, {Character.valueOf('z'), 51}, {Character.valueOf('0'), 52}, {Character.valueOf('1'), 53}, {Character.valueOf('2'), 54}, {Character.valueOf('3'), 55}, {Character.valueOf('4'), 56}, {Character.valueOf('5'), 57}, {Character.valueOf('6'), 58}, {Character.valueOf('7'), 59}, {Character.valueOf('8'), 60}, {Character.valueOf('9'), 61}, {Character.valueOf('-'), 62}, {Character.valueOf('_'), 63}).collect(Collectors.toMap(data -> (Character)data[0], data -> (Integer)data[1]));
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);
    private static Pattern BASE64URL_VERIFICATION_PATTERN = Pattern.compile("^[A-Za-z0-9\\-_]*$", 2);

    protected abstract String pad(String var1);

    public String encode(String bitString) {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches()) {
            throw new EncodingException("Unencodable Base64Url '" + bitString + "'");
        }
        bitString = this.pad(bitString);
        String str = "";
        for (int index = 0; index <= bitString.length() - 6; index += 6) {
            String s = bitString.substring(index, index + 6);
            try {
                int n = FixedIntegerEncoder.decode(s);
                Character c = Character.valueOf(DICT.charAt(n));
                str = str + c;
                continue;
            }
            catch (DecodingException e) {
                throw new EncodingException("Unencodable Base64Url '" + bitString + "'");
            }
        }
        return str;
    }

    public String decode(String str) {
        if (!BASE64URL_VERIFICATION_PATTERN.matcher(str).matches()) {
            throw new DecodingException("Undecodable Base64URL string");
        }
        String bitString = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Integer n = REVERSE_DICT.get(Character.valueOf(c));
            String s = FixedIntegerEncoder.encode(n, 6);
            bitString = bitString + s;
        }
        return bitString;
    }
}

