/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype;

import com.iab.gpp.encoder.datatype.AbstractEncodableBitStringDataType;
import com.iab.gpp.encoder.datatype.EncodableFixedIntegerRange;
import com.iab.gpp.encoder.datatype.SubstringException;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.datatype.encoder.OptimizedFixedRangeEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public class EncodableOptimizedFixedRange
extends AbstractEncodableBitStringDataType<List<Integer>> {
    protected EncodableOptimizedFixedRange() {
        super(true);
    }

    public EncodableOptimizedFixedRange(List<Integer> value) {
        super(true);
        this.setValue(value);
    }

    public EncodableOptimizedFixedRange(List<Integer> value, boolean hardFailIfMissing) {
        super(hardFailIfMissing);
        this.setValue(value);
    }

    @Override
    public String encode() {
        try {
            return OptimizedFixedRangeEncoder.encode((List)this.value);
        }
        catch (Exception e) {
            throw new EncodingException(e);
        }
    }

    @Override
    public void decode(String bitString) {
        try {
            this.value = OptimizedFixedRangeEncoder.decode(bitString);
        }
        catch (Exception e) {
            throw new DecodingException(e);
        }
    }

    @Override
    public String substring(String bitString, int fromIndex) throws SubstringException {
        try {
            int max = FixedIntegerEncoder.decode(bitString.substring(fromIndex, fromIndex + 16));
            if (bitString.charAt(fromIndex + 16) == '1') {
                return bitString.substring(fromIndex, fromIndex + 17) + new EncodableFixedIntegerRange().substring(bitString, fromIndex + 17);
            }
            return bitString.substring(fromIndex, fromIndex + 17 + max);
        }
        catch (Exception e) {
            throw new SubstringException(e);
        }
    }

    @Override
    public void setValue(Object value) {
        super.setValue(new ArrayList(new TreeSet((List)value)));
    }

    @Override
    public List<Integer> getValue() {
        return new ArrayList<Integer>((Collection)super.getValue());
    }
}

