/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.BooleanEncoder;
import com.iab.gpp.encoder.datatype.encoder.FibonacciIntegerEncoder;
import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class FibonacciIntegerRangeEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(List<Integer> value) {
        Collections.sort(value);
        ArrayList<List<Integer>> groups = new ArrayList<List<Integer>>();
        int offset = 0;
        int groupStartIndex = 0;
        while (groupStartIndex < value.size()) {
            int groupEndIndex;
            for (groupEndIndex = groupStartIndex; groupEndIndex < value.size() - 1 && value.get(groupEndIndex) + 1 == value.get(groupEndIndex + 1); ++groupEndIndex) {
            }
            groups.add(value.subList(groupStartIndex, groupEndIndex + 1));
            groupStartIndex = groupEndIndex + 1;
        }
        String bitString = FixedIntegerEncoder.encode(groups.size(), 12);
        for (int i = 0; i < groups.size(); ++i) {
            if (((List)groups.get(i)).size() == 1) {
                int v = (Integer)((List)groups.get(i)).get(0) - offset;
                offset = (Integer)((List)groups.get(i)).get(0);
                bitString = bitString + "0" + FibonacciIntegerEncoder.encode(v);
                continue;
            }
            int startVal = (Integer)((List)groups.get(i)).get(0) - offset;
            offset = (Integer)((List)groups.get(i)).get(0);
            int endVal = (Integer)((List)groups.get(i)).get(((List)groups.get(i)).size() - 1) - offset;
            offset = (Integer)((List)groups.get(i)).get(((List)groups.get(i)).size() - 1);
            bitString = bitString + "1" + FibonacciIntegerEncoder.encode(startVal) + FibonacciIntegerEncoder.encode(endVal);
        }
        return bitString;
    }

    public static List<Integer> decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() < 12) {
            throw new DecodingException("Undecodable FibonacciIntegerRange '" + bitString + "'");
        }
        ArrayList<Integer> value = new ArrayList<Integer>();
        int count = FixedIntegerEncoder.decode(bitString.substring(0, 12));
        int offset = 0;
        int startIndex = 12;
        for (int i = 0; i < count; ++i) {
            int val;
            int index;
            boolean group = BooleanEncoder.decode(bitString.substring(startIndex, startIndex + 1));
            ++startIndex;
            if (group) {
                int end;
                int start;
                index = bitString.indexOf("11", startIndex);
                offset = start = FibonacciIntegerEncoder.decode(bitString.substring(startIndex, index + 2)) + offset;
                startIndex = index + 2;
                index = bitString.indexOf("11", startIndex);
                offset = end = FibonacciIntegerEncoder.decode(bitString.substring(startIndex, index + 2)) + offset;
                startIndex = index + 2;
                for (int j = start; j <= end; ++j) {
                    value.add(j);
                }
                continue;
            }
            index = bitString.indexOf("11", startIndex);
            offset = val = FibonacciIntegerEncoder.decode(bitString.substring(startIndex, index + 2)) + offset;
            value.add(val);
            startIndex = index + 2;
        }
        return value;
    }
}

