/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.regex.Pattern;

public class FixedLongEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(long value, int bitStringLength) {
        String bitString = "";
        while (value > 0L) {
            bitString = (value & 1L) == 1L ? "1" + bitString : "0" + bitString;
            value >>= 1;
        }
        if (bitString.length() > bitStringLength) {
            throw new EncodingException("Numeric value '" + value + "' is too large for a bit string length of '" + bitStringLength + "'");
        }
        while (bitString.length() < bitStringLength) {
            bitString = "0" + bitString;
        }
        return bitString;
    }

    public static long decode(String bitString) throws DecodingException {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches()) {
            throw new DecodingException("Undecodable FixedLong '" + bitString + "'");
        }
        long value = 0L;
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(bitString.length() - (i + 1)) != '1') continue;
            value += 1L << i;
        }
        return value;
    }
}

