/*
 * Decompiled with CFR 0.152.
 */
package com.iab.gpp.encoder.datatype.encoder;

import com.iab.gpp.encoder.datatype.encoder.FixedIntegerEncoder;
import com.iab.gpp.encoder.error.DecodingException;
import com.iab.gpp.encoder.error.EncodingException;
import java.util.regex.Pattern;

public class FixedStringEncoder {
    private static Pattern BITSTRING_VERIFICATION_PATTERN = Pattern.compile("^[0-1]*$", 2);

    public static String encode(String value, int stringLength) {
        while (value.length() < stringLength) {
            value = value + " ";
        }
        String bitString = "";
        for (int i = 0; i < value.length(); ++i) {
            char code = value.charAt(i);
            if (code == ' ') {
                bitString = bitString + FixedIntegerEncoder.encode(63, 6);
                continue;
            }
            if (code >= 'A') {
                bitString = bitString + FixedIntegerEncoder.encode(value.charAt(i) - 65, 6);
                continue;
            }
            throw new EncodingException("Unencodable FixedString '" + value + "'");
        }
        return bitString;
    }

    public static String decode(String bitString) {
        if (!BITSTRING_VERIFICATION_PATTERN.matcher(bitString).matches() || bitString.length() % 6 != 0) {
            throw new DecodingException("Undecodable FixedString '" + bitString + "'");
        }
        String value = "";
        for (int i = 0; i < bitString.length(); i += 6) {
            int code = FixedIntegerEncoder.decode(bitString.substring(i, i + 6));
            value = code == 63 ? value + " " : value + (char)(code + 65);
        }
        return value.trim();
    }
}

